/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.filter;

import java.util.Map;
import org.apache.ivy.osgi.filter.OSGiFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareFilter
extends OSGiFilter {
    private Operator operator;
    private final String rightValue;
    private final String leftValue;

    public CompareFilter(String leftValue, Operator operator, String rightValue) {
        this.leftValue = leftValue;
        this.rightValue = rightValue;
        this.operator = operator;
    }

    public String getLeftValue() {
        return this.leftValue;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public String getRightValue() {
        return this.rightValue;
    }

    @Override
    public void append(StringBuffer builder) {
        builder.append("(");
        builder.append(this.leftValue);
        builder.append(this.operator.toString());
        builder.append(this.rightValue);
        builder.append(")");
    }

    @Override
    public boolean eval(Map<String, String> properties) {
        String actualValue = properties.get(this.leftValue);
        if (actualValue == null) {
            return false;
        }
        int diff = this.rightValue.compareTo(actualValue);
        switch (this.operator) {
            case EQUALS: {
                return diff == 0;
            }
            case GREATER_THAN: {
                return diff > 0;
            }
            case GREATER_OR_EQUAL: {
                return diff >= 0;
            }
            case LOWER_OR_EQUAL: {
                return diff <= 0;
            }
            case LOWER_THAN: {
                return diff < 0;
            }
        }
        throw new IllegalStateException();
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.leftValue == null ? 0 : this.leftValue.hashCode());
        result2 = 31 * result2 + (this.operator == null ? 0 : this.operator.hashCode());
        result2 = 31 * result2 + (this.rightValue == null ? 0 : this.rightValue.hashCode());
        return result2;
    }

    public boolean equals(Object obj2) {
        if (this == obj2) {
            return true;
        }
        if (obj2 == null) {
            return false;
        }
        if (!(obj2 instanceof CompareFilter)) {
            return false;
        }
        CompareFilter other = (CompareFilter)obj2;
        if (this.leftValue == null ? other.leftValue != null : !this.leftValue.equals(other.leftValue)) {
            return false;
        }
        if (this.operator == null ? other.operator != null : !this.operator.equals((Object)other.operator)) {
            return false;
        }
        return !(this.rightValue == null ? other.rightValue != null : !this.rightValue.equals(other.rightValue));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator {
        EQUALS("="),
        LOWER_THAN("<"),
        LOWER_OR_EQUAL("<="),
        GREATER_THAN(">"),
        GREATER_OR_EQUAL(">=");

        private String op;

        private Operator(String op) {
            this.op = op;
        }

        public String toString() {
            return this.op;
        }
    }
}

