/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.core;

import java.text.ParseException;
import java.util.Comparator;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.plugins.latest.ArtifactInfo;
import org.apache.ivy.plugins.latest.ComparatorLatestStrategy;
import org.apache.ivy.plugins.version.VersionMatcher;

public class OsgiLatestStrategy
extends ComparatorLatestStrategy {
    private final Comparator<ModuleRevisionId> mridComparator = new MridComparator();
    private final Comparator<ArtifactInfo> artifactInfoComparator = new ArtifactInfoComparator();

    public OsgiLatestStrategy() {
        this.setComparator(this.artifactInfoComparator);
        this.setName("latest-osgi");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ArtifactInfoComparator
    implements Comparator<ArtifactInfo> {
        ArtifactInfoComparator() {
        }

        @Override
        public int compare(ArtifactInfo o1, ArtifactInfo o2) {
            String rev1 = o1.getRevision();
            String rev2 = o2.getRevision();
            VersionMatcher vmatcher = IvyContext.getContext().getSettings().getVersionMatcher();
            ModuleRevisionId mrid1 = ModuleRevisionId.newInstance("", "", rev1);
            ModuleRevisionId mrid2 = ModuleRevisionId.newInstance("", "", rev2);
            if (vmatcher.isDynamic(mrid1)) {
                int c2 = vmatcher.compare(mrid1, mrid2, OsgiLatestStrategy.this.mridComparator);
                return c2 >= 0 ? 1 : -1;
            }
            if (vmatcher.isDynamic(mrid2)) {
                int c3 = vmatcher.compare(mrid2, mrid1, OsgiLatestStrategy.this.mridComparator);
                return c3 >= 0 ? -1 : 1;
            }
            return OsgiLatestStrategy.this.mridComparator.compare(mrid1, mrid2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class MridComparator
    implements Comparator<ModuleRevisionId> {
        MridComparator() {
        }

        @Override
        public int compare(ModuleRevisionId o1, ModuleRevisionId o2) {
            Version v2;
            Version v1;
            try {
                v1 = new Version(o1.getRevision());
                v2 = new Version(o2.getRevision());
            }
            catch (ParseException e2) {
                throw new RuntimeException("Uncomparable versions:" + o1.getRevision() + " and " + o2.getRevision() + " (" + e2.getMessage() + ")");
            }
            try {
                return v1.compareTo(v2);
            }
            catch (RuntimeException e3) {
                if (e3.getCause() instanceof ParseException) {
                    throw new RuntimeException("Uncomparable versions:" + o1.getRevision() + " and " + o2.getRevision() + " (" + e3.getMessage() + ")");
                }
                throw e3;
            }
        }
    }
}

