/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.ivy.osgi.core.BundleCapability;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.BundleRequirement;
import org.apache.ivy.osgi.core.ExportPackage;
import org.apache.ivy.osgi.core.ManifestHeaderElement;
import org.apache.ivy.osgi.core.ManifestHeaderValue;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.osgi.util.VersionRange;

public class ManifestParser {
    private static final String EXPORT_PACKAGE = "Export-Package";
    private static final String IMPORT_PACKAGE = "Import-Package";
    private static final String EXPORT_SERVICE = "Export-Service";
    private static final String IMPORT_SERVICE = "Import-Service";
    private static final String REQUIRE_BUNDLE = "Require-Bundle";
    private static final String BUNDLE_VERSION = "Bundle-Version";
    private static final String BUNDLE_NAME = "Bundle-Name";
    private static final String BUNDLE_DESCRIPTION = "Bundle-Description";
    private static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    private static final String BUNDLE_MANIFEST_VERSION = "Bundle-ManifestVersion";
    private static final String BUNDLE_REQUIRED_EXECUTION_ENVIRONMENT = "Bundle-RequiredExecutionEnvironment";
    private static final String BUNDLE_CLASSPATH = "Bundle-ClassPath";
    private static final String ECLIPSE_SOURCE_BUNDLE = "Eclipse-SourceBundle";
    private static final String ATTR_RESOLUTION = "resolution";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_BUNDLE_VERSION = "bundle-version";
    private static final String ATTR_USE = "use";

    public static BundleInfo parseJarManifest(InputStream jarStream) throws IOException, ParseException {
        JarInputStream jis = new JarInputStream(jarStream);
        Manifest manifest = jis.getManifest();
        if (manifest == null) {
            return null;
        }
        BundleInfo bundleInfo = ManifestParser.parseManifest(manifest);
        return bundleInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BundleInfo parseManifest(File manifestFile) throws IOException, ParseException {
        FileInputStream fis = new FileInputStream(manifestFile);
        try {
            BundleInfo parseManifest;
            BundleInfo bundleInfo = parseManifest = ManifestParser.parseManifest(fis);
            return bundleInfo;
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e2) {}
        }
    }

    public static BundleInfo parseManifest(String manifest) throws IOException, ParseException {
        ByteArrayInputStream bais = new ByteArrayInputStream(manifest.getBytes("UTF-8"));
        BundleInfo parseManifest = ManifestParser.parseManifest(bais);
        bais.close();
        return parseManifest;
    }

    public static BundleInfo parseManifest(InputStream manifestStream) throws IOException, ParseException {
        BundleInfo parseManifest = ManifestParser.parseManifest(new Manifest(manifestStream));
        return parseManifest;
    }

    public static BundleInfo parseManifest(Manifest manifest) throws ParseException {
        String bundleClasspath;
        Version version2;
        Attributes mainAttributes = manifest.getMainAttributes();
        String symbolicName = new ManifestHeaderValue(mainAttributes.getValue(BUNDLE_SYMBOLIC_NAME)).getSingleValue();
        if (symbolicName == null) {
            throw new ParseException("No Bundle-SymbolicName in the manifest", 0);
        }
        String description = new ManifestHeaderValue(mainAttributes.getValue(BUNDLE_DESCRIPTION)).getSingleValue();
        if (description == null) {
            description = new ManifestHeaderValue(mainAttributes.getValue(BUNDLE_DESCRIPTION)).getSingleValue();
        }
        String vBundle = new ManifestHeaderValue(mainAttributes.getValue(BUNDLE_VERSION)).getSingleValue();
        try {
            version2 = ManifestParser.versionOf(vBundle);
        }
        catch (NumberFormatException e2) {
            throw new ParseException("The Bundle-Version has an incorrect version: " + vBundle + " (" + e2.getMessage() + ")", 0);
        }
        BundleInfo bundleInfo = new BundleInfo(symbolicName, version2);
        bundleInfo.setDescription(description);
        List<String> environments = new ManifestHeaderValue(mainAttributes.getValue(BUNDLE_REQUIRED_EXECUTION_ENVIRONMENT)).getValues();
        bundleInfo.setExecutionEnvironments(environments);
        ManifestParser.parseRequirement(bundleInfo, mainAttributes, REQUIRE_BUNDLE, "bundle", ATTR_BUNDLE_VERSION);
        ManifestParser.parseRequirement(bundleInfo, mainAttributes, IMPORT_PACKAGE, "package", ATTR_VERSION);
        ManifestParser.parseRequirement(bundleInfo, mainAttributes, IMPORT_SERVICE, "service", ATTR_VERSION);
        ManifestHeaderValue exportElements = new ManifestHeaderValue(mainAttributes.getValue(EXPORT_PACKAGE));
        for (ManifestHeaderElement exportElement : exportElements.getElements()) {
            String vExport = exportElement.getAttributes().get(ATTR_VERSION);
            Version v2 = null;
            try {
                v2 = ManifestParser.versionOf(vExport);
            }
            catch (NumberFormatException e3) {
                throw new ParseException("The Export-Package has an incorrect version: " + vExport + " (" + e3.getMessage() + ")", 0);
            }
            for (String name : exportElement.getValues()) {
                ExportPackage export = new ExportPackage(name, v2);
                String uses = exportElement.getDirectives().get(ATTR_USE);
                if (uses != null) {
                    String[] split2 = uses.trim().split(",");
                    for (int i = 0; i < split2.length; ++i) {
                        export.addUse(split2[i].trim());
                    }
                }
                bundleInfo.addCapability(export);
            }
        }
        ManifestParser.parseCapability(bundleInfo, mainAttributes, EXPORT_SERVICE, "service");
        String eclipseSourceBundle = mainAttributes.getValue(ECLIPSE_SOURCE_BUNDLE);
        if (eclipseSourceBundle != null) {
            bundleInfo.setSource(true);
            ManifestHeaderValue eclipseSourceBundleValue = new ManifestHeaderValue(eclipseSourceBundle);
            ManifestHeaderElement element2 = eclipseSourceBundleValue.getElements().iterator().next();
            String symbolicNameTarget = element2.getValues().iterator().next();
            bundleInfo.setSymbolicNameTarget(symbolicNameTarget);
            String v3 = element2.getAttributes().get(ATTR_VERSION);
            if (v3 != null) {
                bundleInfo.setVersionTarget(new Version(v3));
            }
        }
        if ((bundleClasspath = mainAttributes.getValue(BUNDLE_CLASSPATH)) != null) {
            ManifestHeaderValue bundleClasspathValue = new ManifestHeaderValue(bundleClasspath);
            bundleInfo.setClasspath(bundleClasspathValue.getValues());
        }
        return bundleInfo;
    }

    private static void parseRequirement(BundleInfo bundleInfo, Attributes mainAttributes, String headerName, String type, String versionAttr) throws ParseException {
        ManifestHeaderValue elements = new ManifestHeaderValue(mainAttributes.getValue(headerName));
        for (ManifestHeaderElement element2 : elements.getElements()) {
            String resolution = element2.getDirectives().get(ATTR_RESOLUTION);
            String attVersion = element2.getAttributes().get(versionAttr);
            VersionRange version2 = null;
            try {
                version2 = ManifestParser.versionRangeOf(attVersion);
            }
            catch (ParseException e2) {
                throw new ParseException("The " + headerName + " has an incorrect version: " + attVersion + " (" + e2.getMessage() + ")", 0);
            }
            for (String name : element2.getValues()) {
                bundleInfo.addRequirement(new BundleRequirement(type, name, version2, resolution));
            }
        }
    }

    private static void parseCapability(BundleInfo bundleInfo, Attributes mainAttributes, String headerName, String type) throws ParseException {
        ManifestHeaderValue elements = new ManifestHeaderValue(mainAttributes.getValue(headerName));
        for (ManifestHeaderElement element2 : elements.getElements()) {
            String attVersion = element2.getAttributes().get(ATTR_VERSION);
            Version version2 = null;
            try {
                version2 = ManifestParser.versionOf(attVersion);
            }
            catch (NumberFormatException e2) {
                throw new ParseException("The " + headerName + " has an incorrect version: " + attVersion + " (" + e2.getMessage() + ")", 0);
            }
            for (String name : element2.getValues()) {
                BundleCapability export = new BundleCapability(type, name, version2);
                bundleInfo.addCapability(export);
            }
        }
    }

    private static VersionRange versionRangeOf(String v2) throws ParseException {
        if (v2 == null) {
            return null;
        }
        return new VersionRange(v2);
    }

    private static Version versionOf(String v2) throws ParseException {
        if (v2 == null) {
            return null;
        }
        return new Version(v2);
    }

    public static String formatLines(String manifest) {
        StringBuffer buffer2 = new StringBuffer(manifest.length());
        String[] lines = manifest.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].length() <= 72) {
                buffer2.append(lines[i]);
                buffer2.append('\n');
                continue;
            }
            buffer2.append(lines[i].substring(0, 72));
            buffer2.append("\n ");
            int n = 72;
            while (n <= lines[i].length() - 1) {
                int end2 = n + 71;
                if (end2 > lines[i].length()) {
                    end2 = lines[i].length();
                }
                buffer2.append(lines[i].substring(n, end2));
                buffer2.append('\n');
                if (end2 != lines[i].length()) {
                    buffer2.append(' ');
                }
                n = end2;
            }
        }
        return buffer2.toString();
    }
}

