/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.sort;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.sort.ModuleDescriptorSorter;
import org.apache.ivy.core.sort.SortEngineSettings;
import org.apache.ivy.core.sort.SortOptions;
import org.apache.ivy.plugins.circular.CircularDependencyException;
import org.apache.ivy.plugins.circular.CircularDependencyStrategy;
import org.apache.ivy.plugins.circular.IgnoreCircularDependencyStrategy;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.util.Checks;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortEngine {
    private SortEngineSettings settings;

    public SortEngine(SortEngineSettings settings) {
        if (settings == null) {
            throw new NullPointerException("SortEngine.settings can not be null");
        }
        this.settings = settings;
    }

    public List<IvyNode> sortNodes(Collection<IvyNode> nodes, SortOptions options2) {
        LinkedHashMap<ModuleDescriptor, ArrayList<IvyNode>> dependenciesMap = new LinkedHashMap<ModuleDescriptor, ArrayList<IvyNode>>();
        ArrayList<IvyNode> nulls = new ArrayList<IvyNode>();
        for (IvyNode node4 : nodes) {
            if (node4.getDescriptor() == null) {
                nulls.add(node4);
                continue;
            }
            ArrayList<IvyNode> n = (ArrayList<IvyNode>)dependenciesMap.get(node4.getDescriptor());
            if (n == null) {
                n = new ArrayList<IvyNode>();
                dependenciesMap.put(node4.getDescriptor(), n);
            }
            n.add(node4);
        }
        List<ModuleDescriptor> list2 = this.sortModuleDescriptors(dependenciesMap.keySet(), options2);
        double adjustFactor = 1.3;
        ArrayList<IvyNode> ret = new ArrayList<IvyNode>((int)((double)list2.size() * 1.3 + (double)nulls.size()));
        for (int i = 0; i < list2.size(); ++i) {
            ModuleDescriptor md = list2.get(i);
            List n = (List)dependenciesMap.get(md);
            ret.addAll(n);
        }
        ret.addAll(0, nulls);
        return ret;
    }

    public List<ModuleDescriptor> sortModuleDescriptors(Collection<ModuleDescriptor> moduleDescriptors, SortOptions options2) throws CircularDependencyException {
        Checks.checkNotNull(options2, "options");
        ModuleDescriptorSorter sorter = new ModuleDescriptorSorter(moduleDescriptors, this.getVersionMatcher(), options2.getNonMatchingVersionReporter(), options2.isUseCircularDependencyStrategy() ? this.getCircularStrategy() : IgnoreCircularDependencyStrategy.getInstance());
        return sorter.sortModuleDescriptors();
    }

    protected CircularDependencyStrategy getCircularStrategy() {
        return this.settings.getCircularDependencyStrategy();
    }

    protected VersionMatcher getVersionMatcher() {
        return this.settings.getVersionMatcher();
    }
}

