/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.settings;

import java.util.HashMap;
import java.util.Map;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.settings.IvyVariableContainer;
import org.apache.ivy.util.Message;

public class IvyVariableContainerImpl
implements IvyVariableContainer {
    private Map variables;
    private String envPrefix;

    public IvyVariableContainerImpl() {
        this.variables = new HashMap();
    }

    public IvyVariableContainerImpl(Map variables2) {
        this.variables = variables2;
    }

    public void setVariable(String varName, String value2, boolean overwrite) {
        if (overwrite || !this.variables.containsKey(varName)) {
            Message.debug("setting '" + varName + "' to '" + value2 + "'");
            this.variables.put(varName, this.substitute(value2));
        } else {
            Message.debug("'" + varName + "' already set: discarding '" + value2 + "'");
        }
    }

    public void setEnvironmentPrefix(String prefix) {
        this.envPrefix = prefix != null && !prefix.endsWith(".") ? prefix + "." : prefix;
    }

    protected String substitute(String value2) {
        return IvyPatternHelper.substituteVariables(value2, this);
    }

    protected Map getVariables() {
        return this.variables;
    }

    protected String getEnvironmentPrefix() {
        return this.envPrefix;
    }

    public String getVariable(String name) {
        String val = null;
        val = this.envPrefix != null && name.startsWith(this.envPrefix) ? System.getenv(name.substring(this.envPrefix.length())) : (String)this.variables.get(name);
        return val;
    }

    public Object clone() {
        IvyVariableContainerImpl clone;
        try {
            clone = (IvyVariableContainerImpl)super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException("unable to clone a " + this.getClass());
        }
        clone.variables = new HashMap(this.variables);
        return clone;
    }
}

