/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.resolve;

import java.util.Date;
import org.apache.ivy.core.LogOptions;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.util.ConfigurationUtils;
import org.apache.ivy.util.filter.Filter;
import org.apache.ivy.util.filter.FilterHelper;

public class ResolveOptions
extends LogOptions {
    public static final String RESOLVEMODE_DEFAULT = "default";
    public static final String RESOLVEMODE_DYNAMIC = "dynamic";
    public static final String[] RESOLVEMODES = new String[]{"default", "dynamic"};
    private String[] confs = new String[]{"*"};
    private String revision = null;
    private Date date = null;
    private boolean validate = true;
    private boolean useCacheOnly = false;
    private boolean transitive = true;
    private boolean download = true;
    private boolean outputReport = true;
    private Filter artifactFilter = FilterHelper.NO_FILTER;
    private String resolveMode;
    private String resolveId;
    private boolean refresh;
    private boolean checkIfChanged = false;

    public ResolveOptions() {
    }

    public ResolveOptions(ResolveOptions options2) {
        super(options2);
        this.confs = options2.confs;
        this.revision = options2.revision;
        this.date = options2.date;
        this.validate = options2.validate;
        this.refresh = options2.refresh;
        this.useCacheOnly = options2.useCacheOnly;
        this.transitive = options2.transitive;
        this.download = options2.download;
        this.outputReport = options2.outputReport;
        this.resolveMode = options2.resolveMode;
        this.artifactFilter = options2.artifactFilter;
        this.resolveId = options2.resolveId;
        this.checkIfChanged = options2.checkIfChanged;
    }

    public Filter getArtifactFilter() {
        return this.artifactFilter;
    }

    public ResolveOptions setArtifactFilter(Filter artifactFilter) {
        this.artifactFilter = artifactFilter;
        return this;
    }

    public String getResolveMode() {
        return this.resolveMode;
    }

    public ResolveOptions setResolveMode(String resolveMode) {
        this.resolveMode = resolveMode;
        return this;
    }

    public boolean useSpecialConfs() {
        for (int i = 0; this.confs != null && i < this.confs.length; ++i) {
            if (!this.confs[0].startsWith("*")) continue;
            return true;
        }
        return false;
    }

    public String[] getConfs() {
        if (this.useSpecialConfs()) {
            throw new AssertionError((Object)"ResolveOptions.getConfs() can not be used for options used special confs.");
        }
        return this.confs;
    }

    public String[] getConfs(ModuleDescriptor md) {
        return ConfigurationUtils.replaceWildcards(this.confs, md);
    }

    public ResolveOptions setConfs(String[] confs) {
        this.confs = confs;
        return this;
    }

    public Date getDate() {
        return this.date;
    }

    public ResolveOptions setDate(Date date) {
        this.date = date;
        return this;
    }

    public boolean isDownload() {
        return this.download;
    }

    public ResolveOptions setDownload(boolean download2) {
        this.download = download2;
        return this;
    }

    public boolean isOutputReport() {
        return this.outputReport;
    }

    public ResolveOptions setOutputReport(boolean outputReport) {
        this.outputReport = outputReport;
        return this;
    }

    public boolean isTransitive() {
        return this.transitive;
    }

    public ResolveOptions setTransitive(boolean transitive2) {
        this.transitive = transitive2;
        return this;
    }

    public boolean isUseCacheOnly() {
        return this.useCacheOnly;
    }

    public ResolveOptions setUseCacheOnly(boolean useCacheOnly) {
        this.useCacheOnly = useCacheOnly;
        return this;
    }

    public boolean isValidate() {
        return this.validate;
    }

    public ResolveOptions setValidate(boolean validate) {
        this.validate = validate;
        return this;
    }

    public String getRevision() {
        return this.revision;
    }

    public ResolveOptions setRevision(String revision) {
        this.revision = revision;
        return this;
    }

    public String getResolveId() {
        return this.resolveId;
    }

    public ResolveOptions setResolveId(String resolveId) {
        this.resolveId = resolveId;
        return this;
    }

    public ResolveOptions setRefresh(boolean refresh) {
        this.refresh = refresh;
        return this;
    }

    public boolean isRefresh() {
        return this.refresh;
    }

    public ResolveOptions setCheckIfChanged(boolean checkIfChanged) {
        this.checkIfChanged = checkIfChanged;
        return this;
    }

    public boolean getCheckIfChanged() {
        return this.checkIfChanged;
    }

    public static String getDefaultResolveId(ModuleDescriptor md) {
        ModuleId module2 = md.getModuleRevisionId().getModuleId();
        return ResolveOptions.getDefaultResolveId(module2);
    }

    public static String getDefaultResolveId(ModuleId moduleId) {
        return moduleId.getOrganisation() + "-" + moduleId.getName();
    }
}

