/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ConfigurationResolveReport;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.ResolveEngine;
import org.apache.ivy.core.resolve.ResolveEngineSettings;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.core.resolve.VisitData;
import org.apache.ivy.core.resolve.VisitNode;
import org.apache.ivy.util.Message;

public class ResolveData {
    private ResolveEngine engine;
    private Map visitData;
    private ConfigurationResolveReport report;
    private ResolveOptions options;
    private VisitNode currentVisitNode = null;
    private ResolvedModuleRevision currentResolvedModuleRevision;

    public ResolveData(ResolveData data, boolean validate) {
        this(data.engine, new ResolveOptions(data.options).setValidate(validate), data.report, data.visitData);
        this.setCurrentVisitNode(data.currentVisitNode);
        this.setCurrentResolvedModuleRevision(data.currentResolvedModuleRevision);
    }

    public ResolveData(ResolveEngine engine, ResolveOptions options2) {
        this(engine, options2, null, new LinkedHashMap());
    }

    public ResolveData(ResolveEngine engine, ResolveOptions options2, ConfigurationResolveReport report) {
        this(engine, options2, report, new LinkedHashMap());
    }

    public ResolveData(ResolveEngine engine, ResolveOptions options2, ConfigurationResolveReport report, Map visitData) {
        this.engine = engine;
        this.report = report;
        this.visitData = visitData;
        this.options = options2;
    }

    public ConfigurationResolveReport getReport() {
        return this.report;
    }

    public IvyNode getNode(ModuleRevisionId mrid) {
        VisitData visitData = this.getVisitData(mrid);
        return visitData == null ? null : visitData.getNode();
    }

    public Collection getNodes() {
        ArrayList<IvyNode> nodes = new ArrayList<IvyNode>();
        for (VisitData vdata : this.visitData.values()) {
            nodes.add(vdata.getNode());
        }
        return nodes;
    }

    public Collection getNodeIds() {
        return this.visitData.keySet();
    }

    public VisitData getVisitData(ModuleRevisionId mrid) {
        VisitData result2 = (VisitData)this.visitData.get(mrid);
        if (result2 == null) {
            for (Map.Entry entry : this.visitData.entrySet()) {
                ModuleRevisionId current = (ModuleRevisionId)entry.getKey();
                if (!ResolveData.isSubMap(mrid.getAttributes(), current.getAttributes())) continue;
                result2 = (VisitData)entry.getValue();
                break;
            }
        }
        return result2;
    }

    private static boolean isSubMap(Map map1, Map map2) {
        int map2Size;
        int map1Size = map1.size();
        if (map1Size == (map2Size = map2.size())) {
            return ((Object)map1).equals(map2);
        }
        Map smallest = map1Size < map2Size ? map1 : map2;
        Map largest = map1Size < map2Size ? map2 : map1;
        for (Map.Entry entry : smallest.entrySet()) {
            Object map2Value;
            if (!largest.containsKey(entry.getKey())) {
                return false;
            }
            Object map1Value = smallest.get(entry.getKey());
            if (ResolveData.isEqual(map1Value, map2Value = largest.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    private static boolean isEqual(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null) {
            return obj2 == null;
        }
        if (obj2 == null) {
            return obj1 == null;
        }
        return obj1.equals(obj2);
    }

    public VisitNode getCurrentVisitNode() {
        return this.currentVisitNode;
    }

    void setCurrentVisitNode(VisitNode currentVisitNode) {
        this.currentVisitNode = currentVisitNode;
    }

    public void register(VisitNode node4) {
        this.register(node4.getId(), node4);
    }

    public void register(ModuleRevisionId mrid, VisitNode node4) {
        VisitData visitData = this.getVisitData(mrid);
        if (visitData == null) {
            visitData = new VisitData(node4.getNode());
            visitData.addVisitNode(node4);
            this.visitData.put(mrid, visitData);
        } else {
            visitData.setNode(node4.getNode());
            visitData.addVisitNode(node4);
        }
    }

    void replaceNode(ModuleRevisionId mrid, IvyNode node4, String rootModuleConf) {
        VisitData visitData = this.getVisitData(mrid);
        if (visitData == null) {
            throw new IllegalArgumentException("impossible to replace node for id " + mrid + ". No registered node found.");
        }
        VisitData keptVisitData = this.getVisitData(node4.getId());
        if (keptVisitData == null) {
            throw new IllegalArgumentException("impossible to replace node with " + node4 + ". No registered node found for " + node4.getId() + ".");
        }
        this.visitData.put(mrid, keptVisitData);
        keptVisitData.addVisitNodes(rootModuleConf, visitData.getVisitNodes(rootModuleConf));
        this.report.updateDependency(mrid, node4);
    }

    public void setReport(ConfigurationResolveReport report) {
        this.report = report;
    }

    public Date getDate() {
        return this.options.getDate();
    }

    public boolean isValidate() {
        return this.options.isValidate();
    }

    public boolean isTransitive() {
        return this.options.isTransitive();
    }

    public ResolveOptions getOptions() {
        return this.options;
    }

    public ResolveEngineSettings getSettings() {
        return this.engine.getSettings();
    }

    public EventManager getEventManager() {
        return this.engine.getEventManager();
    }

    public ResolveEngine getEngine() {
        return this.engine;
    }

    void blacklist(IvyNode node4) {
        Iterator iter = this.visitData.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            VisitData vdata = (VisitData)entry.getValue();
            if (vdata.getNode() != node4 || node4.getResolvedId().equals(entry.getKey())) continue;
            iter.remove();
        }
    }

    public boolean isBlacklisted(String rootModuleConf, ModuleRevisionId mrid) {
        IvyNode node4 = this.getNode(mrid);
        return node4 != null && node4.isBlacklisted(rootModuleConf);
    }

    public DependencyDescriptor mediate(DependencyDescriptor dd) {
        DependencyDescriptor originalDD = dd;
        dd = this.getEngine().mediate(dd, this.getOptions());
        VisitNode current = this.getCurrentVisitNode();
        if (current != null) {
            ArrayList dependers = new ArrayList(current.getPath());
            dependers.remove(dependers.size() - 1);
            Collections.reverse(dependers);
            for (VisitNode n : dependers) {
                ModuleDescriptor md = n.getDescriptor();
                if (md == null) continue;
                dd = md.mediate(dd);
            }
        }
        if (originalDD != dd) {
            Message.verbose("dependency descriptor has been mediated: " + originalDD + " => " + dd);
        }
        return dd;
    }

    public void setCurrentResolvedModuleRevision(ResolvedModuleRevision mr) {
        this.currentResolvedModuleRevision = mr;
    }

    public ResolvedModuleRevision getCurrentResolvedModuleRevision() {
        return this.currentResolvedModuleRevision;
    }
}

