/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.resolve;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.IncludeRule;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.IvyNodeBlacklist;

public class IvyNodeUsage {
    private IvyNode node;
    private Map rootModuleConfs = new HashMap();
    private Map requiredConfs = new HashMap();
    private Map dependers = new HashMap();
    private Map blacklisted = new HashMap();

    public IvyNodeUsage(IvyNode node4) {
        this.node = node4;
    }

    protected Collection getRequiredConfigurations(IvyNode in2, String inConf) {
        return (Collection)this.requiredConfs.get(new NodeConf(in2, inConf));
    }

    protected void setRequiredConfs(IvyNode parent2, String parentConf, Collection confs) {
        this.requiredConfs.put(new NodeConf(parent2, parentConf), new HashSet(confs));
    }

    protected Set getConfigurations(String rootModuleConf) {
        return (Set)this.rootModuleConfs.get(rootModuleConf);
    }

    protected Set addAndGetConfigurations(String rootModuleConf) {
        HashSet depConfs = (HashSet)this.rootModuleConfs.get(rootModuleConf);
        if (depConfs == null) {
            depConfs = new HashSet();
            this.rootModuleConfs.put(rootModuleConf, depConfs);
        }
        return depConfs;
    }

    protected Set getRootModuleConfigurations() {
        return this.rootModuleConfs.keySet();
    }

    public void updateDataFrom(Collection usages, String rootModuleConf) {
        for (IvyNodeUsage usage : usages) {
            this.updateDataFrom(usage, rootModuleConf);
        }
    }

    private void updateDataFrom(IvyNodeUsage usage, String rootModuleConf) {
        this.updateMapOfSet(usage.requiredConfs, this.requiredConfs);
        this.updateMapOfSetForKey(usage.rootModuleConfs, this.rootModuleConfs, rootModuleConf);
        this.updateMapOfSetForKey(usage.dependers, this.dependers, rootModuleConf);
    }

    private void updateMapOfSet(Map from2, Map to2) {
        for (Object key : from2.keySet()) {
            this.updateMapOfSetForKey(from2, to2, key);
        }
    }

    private void updateMapOfSetForKey(Map from2, Map to2, Object key) {
        Set set2 = (Set)from2.get(key);
        if (set2 != null) {
            Set toupdate = (Set)to2.get(key);
            if (toupdate != null) {
                toupdate.addAll(set2);
            } else {
                to2.put(key, new HashSet(set2));
            }
        }
    }

    private void addObjectsForConf(String rootModuleConf, Object objectToAdd, Map map2) {
        HashSet<Object> set2 = (HashSet<Object>)map2.get(rootModuleConf);
        if (set2 == null) {
            set2 = new HashSet<Object>();
            map2.put(rootModuleConf, set2);
        }
        set2.add(objectToAdd);
    }

    public void addUsage(String rootModuleConf, DependencyDescriptor dd, String parentConf) {
        this.addObjectsForConf(rootModuleConf, new Depender(dd, parentConf), this.dependers);
    }

    protected Set getDependencyArtifactsSet(String rootModuleConf) {
        Collection dependersInConf = (Collection)this.dependers.get(rootModuleConf);
        if (dependersInConf == null) {
            return null;
        }
        HashSet<DependencyArtifactDescriptor> dependencyArtifacts = new HashSet<DependencyArtifactDescriptor>();
        for (Depender depender : dependersInConf) {
            DependencyArtifactDescriptor[] dads = depender.dd.getDependencyArtifacts(depender.dependerConf);
            dependencyArtifacts.addAll(Arrays.asList(dads));
        }
        return dependencyArtifacts;
    }

    protected Set getDependencyIncludesSet(String rootModuleConf) {
        Collection dependersInConf = (Collection)this.dependers.get(rootModuleConf);
        if (dependersInConf == null) {
            return null;
        }
        HashSet<IncludeRule> dependencyIncludes = new HashSet<IncludeRule>();
        for (Depender depender : dependersInConf) {
            IncludeRule[] rules = depender.dd.getIncludeRules(depender.dependerConf);
            if (rules == null || rules.length == 0) {
                return null;
            }
            dependencyIncludes.addAll(Arrays.asList(rules));
        }
        return dependencyIncludes;
    }

    protected void removeRootModuleConf(String rootModuleConf) {
        this.rootModuleConfs.remove(rootModuleConf);
    }

    protected void blacklist(IvyNodeBlacklist bdata) {
        this.blacklisted.put(bdata.getRootModuleConf(), bdata);
    }

    protected boolean isBlacklisted(String rootModuleConf) {
        return this.blacklisted.containsKey(rootModuleConf);
    }

    protected IvyNodeBlacklist getBlacklistData(String rootModuleConf) {
        return (IvyNodeBlacklist)this.blacklisted.get(rootModuleConf);
    }

    protected IvyNode getNode() {
        return this.node;
    }

    public boolean hasTransitiveDepender(String rootModuleConf) {
        Set dependersSet = (Set)this.dependers.get(rootModuleConf);
        if (dependersSet == null) {
            return false;
        }
        for (Depender depender : dependersSet) {
            if (!depender.dd.isTransitive()) continue;
            return true;
        }
        return false;
    }

    private static final class Depender {
        private DependencyDescriptor dd;
        private String dependerConf;

        public Depender(DependencyDescriptor dd, String dependerConf) {
            this.dd = dd;
            this.dependerConf = dependerConf;
        }

        public String toString() {
            return this.dd + " [" + this.dependerConf + "]";
        }

        public boolean equals(Object obj2) {
            if (!(obj2 instanceof Depender)) {
                return false;
            }
            Depender other = (Depender)obj2;
            return other.dd == this.dd && other.dependerConf.equals(this.dependerConf);
        }

        public int hashCode() {
            int hash2 = 33;
            hash2 += this.dd.hashCode() * 13;
            return hash2 += this.dependerConf.hashCode() * 13;
        }
    }

    private static final class NodeConf {
        private IvyNode node;
        private String conf;

        public NodeConf(IvyNode node4, String conf) {
            if (node4 == null) {
                throw new NullPointerException("node must not null");
            }
            if (conf == null) {
                throw new NullPointerException("conf must not null");
            }
            this.node = node4;
            this.conf = conf;
        }

        public final String getConf() {
            return this.conf;
        }

        public final IvyNode getNode() {
            return this.node;
        }

        public boolean equals(Object obj2) {
            if (!(obj2 instanceof NodeConf)) {
                return false;
            }
            return this.getNode().equals(((NodeConf)obj2).getNode()) && this.getConf().equals(((NodeConf)obj2).getConf());
        }

        public int hashCode() {
            int hash2 = 33;
            hash2 += this.getNode().hashCode() * 17;
            return hash2 += this.getConf().hashCode() * 17;
        }

        public String toString() {
            return "NodeConf(" + this.conf + ")";
        }
    }
}

