/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.resolve;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.plugins.conflict.ConflictManager;

public class IvyNodeEviction {
    private IvyNode node;
    private Map selectedDeps = new HashMap();
    private Map pendingConflicts = new HashMap();
    private Map evictedDeps = new HashMap();
    private Map evictedRevs = new HashMap();
    private Map evicted = new HashMap();

    public IvyNodeEviction(IvyNode node4) {
        if (node4 == null) {
            throw new NullPointerException("node must not be null");
        }
        this.node = node4;
    }

    public Set getResolvedNodes(ModuleId mid, String rootModuleConf) {
        Collection resolved = (Collection)this.selectedDeps.get(new ModuleIdConf(mid, rootModuleConf));
        HashSet<IvyNode> ret = new HashSet<IvyNode>();
        if (resolved != null) {
            for (IvyNode node4 : resolved) {
                ret.add(node4.getRealNode());
            }
        }
        return ret;
    }

    public Collection getResolvedRevisions(ModuleId mid, String rootModuleConf) {
        Collection resolved = (Collection)this.selectedDeps.get(new ModuleIdConf(mid, rootModuleConf));
        if (resolved == null) {
            return new HashSet();
        }
        HashSet<ModuleRevisionId> resolvedRevs = new HashSet<ModuleRevisionId>();
        for (IvyNode node4 : resolved) {
            ModuleRevisionId resolvedId = node4.getResolvedId();
            resolvedRevs.add(node4.getId());
            resolvedRevs.add(resolvedId);
            if (resolvedId.getExtraAttributes().isEmpty()) continue;
            resolvedRevs.add(ModuleRevisionId.newInstance(resolvedId.getOrganisation(), resolvedId.getName(), resolvedId.getBranch(), resolvedId.getRevision()));
        }
        return resolvedRevs;
    }

    public void setResolvedNodes(ModuleId moduleId, String rootModuleConf, Collection resolved) {
        ModuleIdConf moduleIdConf = new ModuleIdConf(moduleId, rootModuleConf);
        this.selectedDeps.put(moduleIdConf, new HashSet(resolved));
    }

    public Collection getEvictedNodes(ModuleId mid, String rootModuleConf) {
        Collection resolved = (Collection)this.evictedDeps.get(new ModuleIdConf(mid, rootModuleConf));
        HashSet<IvyNode> ret = new HashSet<IvyNode>();
        if (resolved != null) {
            for (IvyNode node4 : resolved) {
                ret.add(node4.getRealNode());
            }
        }
        return ret;
    }

    public Collection getEvictedRevisions(ModuleId mid, String rootModuleConf) {
        Collection evicted = (Collection)this.evictedRevs.get(new ModuleIdConf(mid, rootModuleConf));
        if (evicted == null) {
            return new HashSet();
        }
        return new HashSet(evicted);
    }

    public void setEvictedNodes(ModuleId moduleId, String rootModuleConf, Collection evicted) {
        ModuleIdConf moduleIdConf = new ModuleIdConf(moduleId, rootModuleConf);
        this.evictedDeps.put(moduleIdConf, new HashSet(evicted));
        HashSet<ModuleRevisionId> evictedRevs = new HashSet<ModuleRevisionId>();
        for (IvyNode node4 : evicted) {
            evictedRevs.add(node4.getId());
            evictedRevs.add(node4.getResolvedId());
        }
        this.evictedRevs.put(moduleIdConf, evictedRevs);
    }

    public boolean isEvicted(String rootModuleConf) {
        ModuleId moduleId;
        this.cleanEvicted();
        if (this.node.isRoot()) {
            return false;
        }
        EvictionData evictedData = this.getEvictedData(rootModuleConf);
        if (evictedData == null) {
            return false;
        }
        IvyNode root = this.node.getRoot();
        Collection resolvedRevisions = root.getResolvedRevisions(moduleId = this.node.getId().getModuleId(), rootModuleConf);
        return !resolvedRevisions.contains(this.node.getResolvedId()) || evictedData.isTransitivelyEvicted();
    }

    public boolean isCompletelyEvicted() {
        this.cleanEvicted();
        if (this.node.isRoot()) {
            return false;
        }
        String[] rootModuleConfigurations = this.node.getRootModuleConfigurations();
        for (int i = 0; i < rootModuleConfigurations.length; ++i) {
            if (this.isEvicted(rootModuleConfigurations[i])) continue;
            return false;
        }
        return true;
    }

    private void cleanEvicted() {
        Iterator iter = this.evicted.keySet().iterator();
        while (iter.hasNext()) {
            String rootModuleConf = (String)iter.next();
            EvictionData ed = (EvictionData)this.evicted.get(rootModuleConf);
            Collection sel = ed.getSelected();
            if (sel == null) continue;
            for (IvyNode n : sel) {
                if (!n.getRealNode().equals(this.node)) continue;
                iter.remove();
            }
        }
    }

    public void markEvicted(EvictionData evictionData) {
        this.evicted.put(evictionData.getRootModuleConf(), evictionData);
    }

    public EvictionData getEvictedData(String rootModuleConf) {
        this.cleanEvicted();
        return (EvictionData)this.evicted.get(rootModuleConf);
    }

    public String[] getEvictedConfs() {
        this.cleanEvicted();
        return this.evicted.keySet().toArray(new String[this.evicted.keySet().size()]);
    }

    public Collection getAllEvictingNodes() {
        HashSet allEvictingNodes = null;
        for (EvictionData ed : this.evicted.values()) {
            Collection selected = ed.getSelected();
            if (selected == null) continue;
            if (allEvictingNodes == null) {
                allEvictingNodes = new HashSet();
            }
            allEvictingNodes.addAll(selected);
        }
        return allEvictingNodes;
    }

    public Collection getAllEvictingNodesDetails() {
        HashSet<String> ret = null;
        for (EvictionData ed : this.evicted.values()) {
            Collection selected = ed.getSelected();
            if (selected == null) continue;
            if (ret == null) {
                ret = new HashSet<String>();
            }
            if (selected.size() == 1) {
                ret.add(selected.iterator().next() + (ed.getDetail() == null ? "" : " " + ed.getDetail()));
                continue;
            }
            if (selected.size() <= 1) continue;
            ret.add(selected + (ed.getDetail() == null ? "" : " " + ed.getDetail()));
        }
        return ret;
    }

    public Collection getAllEvictingConflictManagers() {
        HashSet<ConflictManager> ret = new HashSet<ConflictManager>();
        for (EvictionData ed : this.evicted.values()) {
            ret.add(ed.getConflictManager());
        }
        return ret;
    }

    public EvictionData getEvictionDataInRoot(String rootModuleConf, IvyNode ancestor) {
        Set selectedNodes = this.node.getRoot().getResolvedNodes(this.node.getModuleId(), rootModuleConf);
        for (IvyNode node4 : selectedNodes) {
            if (!node4.getResolvedId().equals(this.node.getResolvedId())) continue;
            return null;
        }
        return new EvictionData(rootModuleConf, ancestor, this.node.getRoot().getConflictManager(this.node.getModuleId()), selectedNodes);
    }

    public Collection getPendingConflicts(String rootModuleConf, ModuleId mid) {
        Collection resolved = (Collection)this.pendingConflicts.get(new ModuleIdConf(mid, rootModuleConf));
        HashSet<IvyNode> ret = new HashSet<IvyNode>();
        if (resolved != null) {
            for (IvyNode node4 : resolved) {
                ret.add(node4.getRealNode());
            }
        }
        return ret;
    }

    public void setPendingConflicts(ModuleId moduleId, String rootModuleConf, Collection conflicts) {
        ModuleIdConf moduleIdConf = new ModuleIdConf(moduleId, rootModuleConf);
        this.pendingConflicts.put(moduleIdConf, new HashSet(conflicts));
    }

    private static final class ModuleIdConf {
        private ModuleId moduleId;
        private String conf;

        public ModuleIdConf(ModuleId mid, String conf) {
            if (mid == null) {
                throw new NullPointerException("mid cannot be null");
            }
            if (conf == null) {
                throw new NullPointerException("conf cannot be null");
            }
            this.moduleId = mid;
            this.conf = conf;
        }

        public final String getConf() {
            return this.conf;
        }

        public final ModuleId getModuleId() {
            return this.moduleId;
        }

        public boolean equals(Object obj2) {
            if (!(obj2 instanceof ModuleIdConf)) {
                return false;
            }
            return this.getModuleId().equals(((ModuleIdConf)obj2).getModuleId()) && this.getConf().equals(((ModuleIdConf)obj2).getConf());
        }

        public int hashCode() {
            int hash2 = 33;
            hash2 += this.getModuleId().hashCode() * 17;
            return hash2 += this.getConf().hashCode() * 17;
        }
    }

    public static class EvictionData {
        private IvyNode parent;
        private ConflictManager conflictManager;
        private Collection selected;
        private String rootModuleConf;
        private String detail;

        public EvictionData(String rootModuleConf, IvyNode parent2, ConflictManager conflictManager, Collection selected) {
            this(rootModuleConf, parent2, conflictManager, selected, null);
        }

        public EvictionData(String rootModuleConf, IvyNode parent2, ConflictManager conflictManager, Collection selected, String detail) {
            this.rootModuleConf = rootModuleConf;
            this.parent = parent2;
            this.conflictManager = conflictManager;
            this.selected = selected;
            this.detail = detail;
        }

        public String toString() {
            if (this.selected != null) {
                return this.selected + " in " + this.parent + (this.detail == null ? "" : " " + this.detail) + " (" + this.conflictManager + ") [" + this.rootModuleConf + "]";
            }
            return "transitively [" + this.rootModuleConf + "]";
        }

        public ConflictManager getConflictManager() {
            return this.conflictManager;
        }

        public IvyNode getParent() {
            return this.parent;
        }

        public Collection getSelected() {
            return this.selected;
        }

        public String getRootModuleConf() {
            return this.rootModuleConf;
        }

        public boolean isTransitivelyEvicted() {
            return this.parent == null;
        }

        public String getDetail() {
            return this.detail;
        }
    }
}

