/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.resolve;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.event.resolve.EndResolveDependencyEvent;
import org.apache.ivy.core.event.resolve.StartResolveDependencyEvent;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.IncludeRule;
import org.apache.ivy.core.module.descriptor.MDArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.IvyNodeBlacklist;
import org.apache.ivy.core.resolve.IvyNodeCallers;
import org.apache.ivy.core.resolve.IvyNodeEviction;
import org.apache.ivy.core.resolve.IvyNodeUsage;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolveEngineSettings;
import org.apache.ivy.core.resolve.ResolveProcessException;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.plugins.conflict.ConflictManager;
import org.apache.ivy.plugins.matcher.MatcherHelper;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.StringUtils;
import org.apache.ivy.util.filter.Filter;
import org.apache.ivy.util.filter.FilterHelper;

public class IvyNode
implements Comparable {
    private static final Pattern FALLBACK_CONF_PATTERN = Pattern.compile("(.+)\\((.*)\\)");
    private ResolveData data;
    private ResolveEngineSettings settings;
    private IvyNodeCallers callers;
    private IvyNodeEviction eviction;
    private IvyNode root;
    private ModuleRevisionId id;
    private Map dds = new HashMap();
    private ModuleDescriptor md;
    private ResolvedModuleRevision module;
    private Exception problem = null;
    private boolean downloaded = false;
    private boolean searched = false;
    private Collection confsToFetch = new HashSet();
    private Collection fetchedConfigurations = new HashSet();
    private Collection loadedRootModuleConfs = new HashSet();
    private IvyNodeUsage usage = new IvyNodeUsage(this);
    private Map mergedUsages = new LinkedHashMap();

    public IvyNode(ResolveData data, IvyNode parent2, DependencyDescriptor dd) {
        this.id = dd.getDependencyRevisionId();
        this.dds.put(parent2, dd);
        this.root = parent2.getRoot();
        this.init(data);
    }

    public IvyNode(ResolveData data, ModuleDescriptor md) {
        this.id = md.getModuleRevisionId();
        this.md = md;
        this.root = this;
        this.init(data);
    }

    private void init(ResolveData data) {
        this.data = data;
        this.settings = data.getSettings();
        this.eviction = new IvyNodeEviction(this);
        this.callers = new IvyNodeCallers(this);
    }

    public boolean loadData(String rootModuleConf, IvyNode parent2, String parentConf, String conf, boolean shouldBePublic, IvyNodeUsage usage) {
        Message.debug("loadData of " + this.toString() + " of rootConf=" + rootModuleConf);
        if (!this.isRoot() && this.data.getReport() != null) {
            this.data.getReport().addDependency(this);
        }
        boolean loaded = false;
        if (this.hasProblem()) {
            Message.debug("Node has problem.  Skip loading");
        } else if (this.isEvicted(rootModuleConf)) {
            Message.debug(rootModuleConf + " is evicted.  Skip loading");
        } else if (!this.hasConfigurationsToLoad() && this.isRootModuleConfLoaded(rootModuleConf)) {
            Message.debug(rootModuleConf + " is loaded and no conf to load.  Skip loading");
        } else {
            this.markRootModuleConfLoaded(rootModuleConf);
            if (this.md == null) {
                DependencyResolver resolver = this.data.getSettings().getResolver(this.getId());
                if (resolver == null) {
                    Message.error("no resolver found for " + this.getModuleId() + ": check your configuration");
                    this.problem = new RuntimeException("no resolver found for " + this.getModuleId() + ": check your configuration");
                    return false;
                }
                try {
                    Message.debug("\tusing " + resolver + " to resolve " + this.getId());
                    DependencyDescriptor dependencyDescriptor = this.getDependencyDescriptor(parent2);
                    long start2 = System.currentTimeMillis();
                    ModuleRevisionId requestedRevisionId = dependencyDescriptor.getDependencyRevisionId();
                    this.data.getEventManager().fireIvyEvent(new StartResolveDependencyEvent(resolver, dependencyDescriptor, requestedRevisionId));
                    this.module = resolver.getDependency(dependencyDescriptor, this.data);
                    this.data.getEventManager().fireIvyEvent(new EndResolveDependencyEvent(resolver, dependencyDescriptor, requestedRevisionId, this.module, System.currentTimeMillis() - start2));
                    if (this.module != null) {
                        this.module.getResolver().getRepositoryCacheManager().saveResolvers(this.module.getDescriptor(), this.module.getResolver().getName(), this.module.getArtifactResolver().getName());
                        if (this.settings.logModuleWhenFound() && "default".equals(this.getData().getOptions().getLog())) {
                            Message.info("\tfound " + this.module.getId() + " in " + this.module.getResolver().getName());
                        } else {
                            Message.verbose("\tfound " + this.module.getId() + " in " + this.module.getResolver().getName());
                        }
                        if (this.settings.getVersionMatcher().isDynamic(this.getId()) && this.settings.getVersionMatcher().isDynamic(this.module.getId())) {
                            Message.error("impossible to resolve dynamic revision for " + this.getId() + ": check your configuration and " + "make sure revision is part of your pattern");
                            this.problem = new RuntimeException("impossible to resolve dynamic revision");
                            return false;
                        }
                        if (!this.getId().equals(this.module.getId())) {
                            IvyNode resolved = this.data.getNode(this.module.getId());
                            if (resolved != null) {
                                this.md = this.module.getDescriptor();
                                if (!this.handleConfiguration(loaded, rootModuleConf, parent2, parentConf, conf, shouldBePublic, usage)) {
                                    return false;
                                }
                                this.moveToRealNode(rootModuleConf, parent2, parentConf, conf, shouldBePublic, resolved);
                                return true;
                            }
                            String log = "\t[" + this.module.getId().getRevision() + "] " + this.getId();
                            if (!this.settings.getVersionMatcher().isDynamic(this.getId())) {
                                log = log + " (forced)";
                            }
                            if (this.settings.logResolvedRevision() && "default".equals(this.getData().getOptions().getLog())) {
                                Message.info(log);
                            } else {
                                Message.verbose(log);
                            }
                        }
                    } else {
                        Message.warn("\tmodule not found: " + this.getId());
                        resolver.reportFailure();
                        this.problem = new RuntimeException("not found");
                        return false;
                    }
                    this.downloaded = this.module.getReport().isDownloaded();
                    this.searched = this.module.getReport().isSearched();
                    loaded = true;
                    this.md = this.module.getDescriptor();
                    this.confsToFetch.remove("*");
                    this.updateConfsToFetch(Arrays.asList(this.resolveSpecialConfigurations(this.getRequiredConfigurations(parent2, parentConf))));
                }
                catch (ResolveProcessException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    this.problem = e3;
                    Message.debug("Unexpected error: " + this.problem.getMessage(), this.problem);
                    return false;
                }
            } else {
                loaded = true;
            }
        }
        this.handleConfiguration(loaded, rootModuleConf, parent2, parentConf, conf, shouldBePublic, usage);
        if (this.hasProblem()) {
            Message.debug("problem : " + this.problem.getMessage());
            return false;
        }
        DependencyDescriptor dd = this.getDependencyDescriptor(parent2);
        if (dd != null) {
            usage.addUsage(rootModuleConf, dd, parentConf);
        }
        return loaded;
    }

    private void moveToRealNode(String rootModuleConf, IvyNode parent2, String parentConf, String conf, boolean shouldBePublic, IvyNode resolved) {
        if (resolved.md == null) {
            resolved.md = this.md;
        }
        if (resolved.module == null) {
            resolved.module = this.module;
        }
        resolved.downloaded |= this.module.getReport().isDownloaded();
        resolved.searched |= this.module.getReport().isSearched();
        resolved.dds.putAll(this.dds);
        resolved.updateDataFrom(this, rootModuleConf, true);
        resolved.loadData(rootModuleConf, parent2, parentConf, conf, shouldBePublic, this.usage);
        resolved.usage.updateDataFrom(this.getAllUsages(), rootModuleConf);
        this.usage = resolved.usage;
        this.data.replaceNode(this.getId(), resolved, rootModuleConf);
        if (this.settings.logResolvedRevision() && "default".equals(this.getData().getOptions().getLog())) {
            Message.info("\t[" + this.module.getId().getRevision() + "] " + this.getId());
        } else {
            Message.verbose("\t[" + this.module.getId().getRevision() + "] " + this.getId());
        }
    }

    public Collection getDependencies(String rootModuleConf, String[] confs, String requestedConf) {
        if (this.md == null) {
            throw new IllegalStateException("impossible to get dependencies when data has not been loaded");
        }
        if (Arrays.asList(confs).contains("*")) {
            confs = this.isRoot() ? this.md.getConfigurationsNames() : this.md.getPublicConfigurationsNames();
        }
        HashSet deps = new HashSet();
        for (int i = 0; i < confs.length; ++i) {
            deps.addAll(this.getDependencies(rootModuleConf, confs[i], requestedConf));
        }
        return deps;
    }

    public Collection getDependencies(String rootModuleConf, String conf, String requestedConf) {
        if (this.md == null) {
            throw new IllegalStateException("impossible to get dependencies when data has not been loaded");
        }
        DependencyDescriptor[] dds = this.md.getDependencies();
        LinkedHashMap<ModuleRevisionId, IvyNode> dependencies2 = new LinkedHashMap<ModuleRevisionId, IvyNode>();
        for (int i = 0; i < dds.length; ++i) {
            DependencyDescriptor dd = this.data.mediate(dds[i]);
            String[] dependencyConfigurations = dd.getDependencyConfigurations(conf, requestedConf);
            if (dependencyConfigurations.length == 0) continue;
            ModuleRevisionId requestedDependencyRevisionId = dd.getDependencyRevisionId();
            if (this.isDependencyModuleExcluded(dd, rootModuleConf, requestedDependencyRevisionId, conf)) {
                Message.verbose("excluding " + dd + " in " + conf);
                continue;
            }
            IvyNode depNode = (IvyNode)dependencies2.get(requestedDependencyRevisionId);
            if (depNode == null) {
                depNode = this.data.getNode(requestedDependencyRevisionId);
            }
            if (depNode == null) {
                depNode = new IvyNode(this.data, this, dd);
            } else {
                depNode.addDependencyDescriptor(this, dd);
                if (depNode.hasProblem()) {
                    // empty if block
                }
            }
            String[] confsArray = depNode.resolveSpecialConfigurations(dependencyConfigurations);
            List<String> confs = Arrays.asList(confsArray);
            depNode.updateConfsToFetch(confs);
            depNode.addRootModuleConfigurations(depNode.usage, rootModuleConf, confsArray);
            depNode.usage.setRequiredConfs(this, conf, confs);
            depNode.addCaller(rootModuleConf, this, conf, requestedConf, dependencyConfigurations, dd);
            dependencies2.put(requestedDependencyRevisionId, depNode);
        }
        return dependencies2.values();
    }

    private void addDependencyDescriptor(IvyNode parent2, DependencyDescriptor dd) {
        this.dds.put(parent2, dd);
    }

    public DependencyDescriptor getDependencyDescriptor(IvyNode parent2) {
        return (DependencyDescriptor)this.dds.get(parent2);
    }

    private boolean isDependencyModuleExcluded(DependencyDescriptor dd, String rootModuleConf, ModuleRevisionId dependencyRevisionId, String conf) {
        Artifact a2 = DefaultArtifact.newIvyArtifact(dependencyRevisionId, null);
        if (this.isRoot()) {
            Boolean exclude = this.doesExclude(this.md, rootModuleConf, new String[]{rootModuleConf}, dd, a2, new Stack());
            return exclude == null ? false : exclude;
        }
        return this.callers.doesCallersExclude(rootModuleConf, a2);
    }

    Boolean doesExclude(ModuleDescriptor md, String rootModuleConf, String[] moduleConfs, DependencyDescriptor dd, Artifact artifact, Stack callersStack) {
        if (dd != null && dd.doesExclude(moduleConfs, artifact.getId().getArtifactId())) {
            return Boolean.TRUE;
        }
        if (md.doesExclude(moduleConfs, artifact.getId().getArtifactId())) {
            return Boolean.TRUE;
        }
        IvyNode c2 = this.getData().getNode(md.getModuleRevisionId());
        if (c2 != null) {
            if (callersStack.contains(c2.getId())) {
                return null;
            }
            return c2.doesCallersExclude(rootModuleConf, artifact, callersStack);
        }
        return Boolean.FALSE;
    }

    public boolean hasConfigurationsToLoad() {
        return !this.confsToFetch.isEmpty();
    }

    private boolean markRootModuleConfLoaded(String rootModuleConf) {
        return this.loadedRootModuleConfs.add(rootModuleConf);
    }

    private boolean isRootModuleConfLoaded(String rootModuleConf) {
        return this.loadedRootModuleConfs.contains(rootModuleConf);
    }

    private boolean handleConfiguration(boolean loaded, String rootModuleConf, IvyNode parent2, String parentConf, String conf, boolean shouldBePublic, IvyNodeUsage usage) {
        if (this.md != null) {
            String[] confs = this.getRealConfs(conf);
            this.addRootModuleConfigurations(usage, rootModuleConf, confs);
            for (int i = 0; i < confs.length; ++i) {
                Configuration c2 = this.md.getConfiguration(confs[i]);
                if (c2 == null) {
                    this.confsToFetch.remove(conf);
                    if (this.isConfRequiredByMergedUsageOnly(rootModuleConf, conf)) {
                        Message.verbose("configuration required by evicted revision is not available in selected revision. skipping " + conf + " in " + this);
                    } else {
                        this.problem = !conf.equals(confs[i]) ? new RuntimeException("configuration not found in " + this + ": '" + conf + "'. Missing configuration: '" + confs[i] + "'. It was required from " + parent2 + " " + parentConf) : new RuntimeException("configuration not found in " + this + ": '" + confs[i] + "'. It was required from " + parent2 + " " + parentConf);
                    }
                    return false;
                }
                if (!shouldBePublic || this.isRoot() || c2.getVisibility() == Configuration.Visibility.PUBLIC) continue;
                this.confsToFetch.remove(conf);
                if (this.isConfRequiredByMergedUsageOnly(rootModuleConf, conf)) {
                    Message.verbose("configuration required by evicted revision is not visible in selected revision. skipping " + conf + " in " + this);
                } else {
                    this.problem = new RuntimeException("configuration not public in " + this + ": '" + c2 + "'. It was required from " + parent2 + " " + parentConf);
                }
                return false;
            }
            if (loaded) {
                this.fetchedConfigurations.add(conf);
                this.confsToFetch.removeAll(Arrays.asList(confs));
                this.confsToFetch.remove(conf);
            }
        }
        return true;
    }

    private String getDefaultConf(String conf) {
        Matcher m = FALLBACK_CONF_PATTERN.matcher(conf);
        if (m.matches()) {
            return m.group(2);
        }
        return conf;
    }

    private String getMainConf(String conf) {
        Matcher m = FALLBACK_CONF_PATTERN.matcher(conf);
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }

    public void updateConfsToFetch(Collection confs) {
        this.confsToFetch.addAll(confs);
        this.confsToFetch.removeAll(this.fetchedConfigurations);
    }

    private String[] resolveSpecialConfigurations(String[] dependencyConfigurations) {
        if (dependencyConfigurations.length == 1 && dependencyConfigurations[0].startsWith("*") && this.isLoaded()) {
            String conf = dependencyConfigurations[0];
            if ("*".equals(conf)) {
                return this.getDescriptor().getPublicConfigurationsNames();
            }
            List<String> exclusions = Arrays.asList(conf.substring(2).split("\\!"));
            ArrayList<String> ret = new ArrayList<String>(Arrays.asList(this.getDescriptor().getPublicConfigurationsNames()));
            ret.removeAll(exclusions);
            return ret.toArray(new String[ret.size()]);
        }
        return dependencyConfigurations;
    }

    public String[] getRequiredConfigurations(IvyNode in2, String inConf) {
        LinkedHashSet req = new LinkedHashSet();
        this.addAllIfNotNull(req, this.usage.getRequiredConfigurations(in2, inConf));
        for (IvyNodeUsage usage : this.mergedUsages.values()) {
            this.addAllIfNotNull(req, usage.getRequiredConfigurations(in2, inConf));
        }
        return req == null ? new String[]{} : req.toArray(new String[req.size()]);
    }

    private void addAllIfNotNull(Collection into, Collection col) {
        if (col != null) {
            into.addAll(col);
        }
    }

    public String[] getRequiredConfigurations() {
        ArrayList required = new ArrayList(this.confsToFetch.size() + this.fetchedConfigurations.size());
        required.addAll(this.fetchedConfigurations);
        required.addAll(this.confsToFetch);
        return required.toArray(new String[required.size()]);
    }

    public Configuration getConfiguration(String conf) {
        if (this.md == null) {
            throw new IllegalStateException("impossible to get configuration when data has not been loaded");
        }
        String defaultConf = this.getDefaultConf(conf);
        Configuration configuration = this.md.getConfiguration(conf = this.getMainConf(conf));
        if (configuration == null) {
            configuration = this.md.getConfiguration(defaultConf);
        }
        return configuration;
    }

    public String[] getConfigurations(String rootModuleConf) {
        LinkedHashSet depConfs = new LinkedHashSet();
        this.addAllIfNotNull(depConfs, this.usage.getConfigurations(rootModuleConf));
        for (IvyNodeUsage usage : this.mergedUsages.values()) {
            this.addAllIfNotNull(depConfs, usage.getConfigurations(rootModuleConf));
        }
        return depConfs.toArray(new String[depConfs.size()]);
    }

    protected boolean isConfRequiredByMergedUsageOnly(String rootModuleConf, String conf) {
        Set confs = this.usage.getConfigurations(rootModuleConf);
        return confs == null || !confs.contains(conf);
    }

    public void discardConf(String rootModuleConf, String conf) {
        Set depConfs = this.usage.addAndGetConfigurations(rootModuleConf);
        if (this.md != null) {
            Configuration c2 = this.md.getConfiguration(conf);
            if (conf != null) {
                String[] exts = c2.getExtends();
                for (int i = 0; i < exts.length; ++i) {
                    this.discardConf(rootModuleConf, exts[i]);
                }
                depConfs.remove(c2.getName());
            } else {
                Message.warn("unknown configuration in " + this.getId() + ": " + conf);
            }
        } else {
            depConfs.remove(conf);
        }
    }

    private void addRootModuleConfigurations(IvyNodeUsage usage, String rootModuleConf, String[] dependencyConfs) {
        Set depConfs = usage.addAndGetConfigurations(rootModuleConf);
        if (this.md != null) {
            for (int i = 0; i < dependencyConfs.length; ++i) {
                depConfs.add(dependencyConfs[i]);
                Configuration conf = this.md.getConfiguration(dependencyConfs[i]);
                if (conf == null) continue;
                String[] exts = conf.getExtends();
                this.addRootModuleConfigurations(usage, rootModuleConf, exts);
            }
        } else {
            for (int i = 0; i < dependencyConfs.length; ++i) {
                depConfs.add(dependencyConfs[i]);
            }
        }
    }

    public String[] getRootModuleConfigurations() {
        Set confs = this.getRootModuleConfigurationsSet();
        return confs.toArray(new String[confs.size()]);
    }

    public Set getRootModuleConfigurationsSet() {
        LinkedHashSet confs = new LinkedHashSet();
        this.addAllIfNotNull(confs, this.usage.getRootModuleConfigurations());
        for (IvyNodeUsage usage : this.mergedUsages.values()) {
            this.addAllIfNotNull(confs, usage.getRootModuleConfigurations());
        }
        return confs;
    }

    public String[] getConfsToFetch() {
        return this.confsToFetch.toArray(new String[this.confsToFetch.size()]);
    }

    public String[] getRealConfs(String conf) {
        if (this.md == null) {
            return new String[]{conf};
        }
        String defaultConf = this.getDefaultConf(conf);
        if (this.md.getConfiguration(conf = this.getMainConf(conf)) == null || Configuration.Visibility.PRIVATE.equals(this.md.getConfiguration(conf).getVisibility())) {
            if ("".equals(defaultConf)) {
                return new String[0];
            }
            conf = defaultConf;
        }
        if (conf.startsWith("*")) {
            return this.resolveSpecialConfigurations(new String[]{conf});
        }
        if (conf.indexOf(44) != -1) {
            String[] confs = conf.split(",");
            for (int i = 0; i < confs.length; ++i) {
                confs[i] = confs[i].trim();
            }
        }
        return new String[]{conf};
    }

    private Collection findPath(ModuleId from2) {
        return this.findPath(from2, this, new LinkedList());
    }

    private Collection findPath(ModuleId from2, IvyNode node4, List path2) {
        IvyNode parent2 = node4.getDirectCallerFor(from2);
        if (parent2 == null) {
            throw new IllegalArgumentException("no path from " + from2 + " to " + this.getId() + " found");
        }
        if (path2.contains(parent2)) {
            path2.add(0, parent2);
            Message.verbose("circular dependency found while looking for the path for another one: was looking for " + from2 + " as a caller of " + path2.get(path2.size() - 1));
            return path2;
        }
        path2.add(0, parent2);
        if (parent2.getId().getModuleId().equals(from2)) {
            return path2;
        }
        return this.findPath(from2, parent2, path2);
    }

    private void updateDataFrom(IvyNode node4, String rootModuleConf, boolean real) {
        this.callers.updateFrom(node4.callers, rootModuleConf, real);
        if (real) {
            this.usage.updateDataFrom(node4.getAllUsages(), rootModuleConf);
        } else {
            IvyNodeUsage mergedUsage = (IvyNodeUsage)this.mergedUsages.get(node4.getId());
            if (mergedUsage == null) {
                mergedUsage = new IvyNodeUsage(node4);
                this.mergedUsages.put(node4.getId(), mergedUsage);
            }
            mergedUsage.updateDataFrom(node4.getAllUsages(), rootModuleConf);
        }
        this.updateConfsToFetch(node4.fetchedConfigurations);
        this.updateConfsToFetch(node4.confsToFetch);
    }

    private Collection getAllUsages() {
        ArrayList<IvyNodeUsage> usages = new ArrayList<IvyNodeUsage>();
        usages.add(this.usage);
        usages.addAll(this.mergedUsages.values());
        return usages;
    }

    public Artifact[] getAllArtifacts() {
        HashSet<Artifact> ret = new HashSet<Artifact>();
        for (String rootModuleConf : this.getRootModuleConfigurationsSet()) {
            ret.addAll(Arrays.asList(this.getArtifacts(rootModuleConf)));
        }
        return ret.toArray(new Artifact[ret.size()]);
    }

    public Artifact[] getSelectedArtifacts(Filter artifactFilter) {
        Collection<Artifact> ret = new HashSet();
        for (String rootModuleConf : this.getRootModuleConfigurationsSet()) {
            if (this.isEvicted(rootModuleConf) || this.isBlacklisted(rootModuleConf)) continue;
            ret.addAll(Arrays.asList(this.getArtifacts(rootModuleConf)));
        }
        ret = FilterHelper.filter(ret, artifactFilter);
        return ret.toArray(new Artifact[ret.size()]);
    }

    public Artifact[] getArtifacts(String rootModuleConf) {
        String[] confs = this.getConfigurations(rootModuleConf);
        if (confs == null || confs.length == 0) {
            return new Artifact[0];
        }
        if (this.md == null) {
            throw new IllegalStateException("impossible to get artifacts when data has not been loaded. IvyNode = " + this.toString());
        }
        HashSet<Artifact> artifacts2 = new HashSet<Artifact>();
        Set dependencyArtifacts = this.usage.getDependencyArtifactsSet(rootModuleConf);
        if (this.md.isDefault() && dependencyArtifacts != null && !dependencyArtifacts.isEmpty()) {
            this.addArtifactsFromOwnUsage(artifacts2, dependencyArtifacts);
            this.addArtifactsFromMergedUsage(rootModuleConf, artifacts2);
        } else {
            LinkedHashSet includes = new LinkedHashSet();
            this.addAllIfNotNull(includes, this.usage.getDependencyIncludesSet(rootModuleConf));
            for (IvyNodeUsage usage : this.mergedUsages.values()) {
                this.addAllIfNotNull(includes, usage.getDependencyIncludesSet(rootModuleConf));
            }
            if ((dependencyArtifacts == null || dependencyArtifacts.isEmpty()) && includes.isEmpty()) {
                for (int i = 0; i < confs.length; ++i) {
                    artifacts2.addAll(Arrays.asList(this.md.getArtifacts(confs[i])));
                }
            } else {
                HashMap<ArtifactId, Artifact> allArtifacts = new HashMap<ArtifactId, Artifact>();
                for (int i = 0; i < confs.length; ++i) {
                    Artifact[] arts = this.md.getArtifacts(confs[i]);
                    for (int j = 0; j < arts.length; ++j) {
                        allArtifacts.put(arts[j].getId().getArtifactId(), arts[j]);
                    }
                }
                if (dependencyArtifacts != null) {
                    this.addArtifactsFromOwnUsage(artifacts2, dependencyArtifacts);
                }
                this.addArtifactsFromMergedUsage(rootModuleConf, artifacts2);
                Iterator it = includes.iterator();
                while (it.hasNext()) {
                    IncludeRule dad = (IncludeRule)it.next();
                    Collection arts = IvyNode.findArtifactsMatching(dad, allArtifacts);
                    if (arts.isEmpty()) {
                        Message.error("a required artifact is not listed by module descriptor: " + dad.getId());
                        it.remove();
                        continue;
                    }
                    Message.debug(this + " in " + rootModuleConf + ": including " + arts);
                    artifacts2.addAll(arts);
                }
            }
        }
        Iterator iter = artifacts2.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            boolean excluded2 = this.callers.doesCallersExclude(rootModuleConf, artifact);
            if (!excluded2) continue;
            Message.debug(this + " in " + rootModuleConf + ": excluding " + artifact);
            iter.remove();
        }
        return artifacts2.toArray(new Artifact[artifacts2.size()]);
    }

    private void addArtifactsFromOwnUsage(Set artifacts2, Set dependencyArtifacts) {
        for (DependencyArtifactDescriptor dad : dependencyArtifacts) {
            artifacts2.add(new MDArtifact(this.md, dad.getName(), dad.getType(), dad.getExt(), dad.getUrl(), dad.getQualifiedExtraAttributes()));
        }
    }

    private void addArtifactsFromMergedUsage(String rootModuleConf, Set artifacts2) {
        for (IvyNodeUsage usage : this.mergedUsages.values()) {
            Set mergedDependencyArtifacts = usage.getDependencyArtifactsSet(rootModuleConf);
            if (mergedDependencyArtifacts == null) continue;
            for (DependencyArtifactDescriptor dad : mergedDependencyArtifacts) {
                HashMap<String, String> extraAttributes2 = new HashMap<String, String>(dad.getQualifiedExtraAttributes());
                MDArtifact artifact = new MDArtifact(this.md, dad.getName(), dad.getType(), dad.getExt(), dad.getUrl(), extraAttributes2);
                if (artifacts2.contains(artifact)) continue;
                extraAttributes2.put("ivy:merged", dad.getDependencyDescriptor().getParentRevisionId() + " -> " + usage.getNode().getId());
                artifacts2.add(artifact);
            }
        }
    }

    private static Collection findArtifactsMatching(IncludeRule rule, Map allArtifacts) {
        ArrayList ret = new ArrayList();
        for (ArtifactId aid : allArtifacts.keySet()) {
            if (!MatcherHelper.matches(rule.getMatcher(), rule.getId(), aid)) continue;
            ret.add(allArtifacts.get(aid));
        }
        return ret;
    }

    public boolean hasProblem() {
        return this.problem != null;
    }

    public Exception getProblem() {
        return this.problem;
    }

    public String getProblemMessage() {
        return StringUtils.getErrorMessage(this.problem);
    }

    public boolean isDownloaded() {
        return this.downloaded;
    }

    public boolean isSearched() {
        return this.searched;
    }

    public boolean isLoaded() {
        return this.md != null;
    }

    public boolean isFetched(String conf) {
        return this.fetchedConfigurations.contains(conf);
    }

    public IvyNode findNode(ModuleRevisionId mrid) {
        return this.data.getNode(mrid);
    }

    boolean isRoot() {
        return this.root == this;
    }

    public IvyNode getRoot() {
        return this.root;
    }

    public ConflictManager getConflictManager(ModuleId mid) {
        if (this.md == null) {
            throw new IllegalStateException("impossible to get conflict manager when data has not been loaded. IvyNode = " + this.toString());
        }
        ConflictManager cm = this.md.getConflictManager(mid);
        return cm == null ? this.settings.getConflictManager(mid) : cm;
    }

    public IvyNode getRealNode() {
        IvyNode real = this.data.getNode(this.getId());
        return real != null ? real : this;
    }

    public ModuleRevisionId getId() {
        return this.id;
    }

    public ModuleId getModuleId() {
        return this.id.getModuleId();
    }

    public ModuleDescriptor getDescriptor() {
        return this.md;
    }

    public ResolveData getData() {
        return this.data;
    }

    public ResolvedModuleRevision getModuleRevision() {
        return this.module;
    }

    public long getPublication() {
        if (this.module != null) {
            return this.module.getPublicationDate().getTime();
        }
        return 0L;
    }

    public long getLastModified() {
        if (this.md != null) {
            return this.md.getLastModified();
        }
        return 0L;
    }

    public ModuleRevisionId getResolvedId() {
        if (this.md != null && this.md.getResolvedModuleRevisionId().getRevision() != null) {
            return this.md.getResolvedModuleRevisionId();
        }
        if (this.module != null) {
            return this.module.getId();
        }
        return this.getId();
    }

    public void clean() {
        this.confsToFetch.clear();
    }

    boolean canExclude(String rootModuleConf) {
        IvyNodeCallers.Caller[] callers = this.getCallers(rootModuleConf);
        for (int i = 0; i < callers.length; ++i) {
            if (!callers[i].canExclude()) continue;
            return true;
        }
        return false;
    }

    private IvyNode getDirectCallerFor(ModuleId from2) {
        return this.callers.getDirectCallerFor(from2);
    }

    public IvyNodeCallers.Caller[] getCallers(String rootModuleConf) {
        return this.callers.getCallers(rootModuleConf);
    }

    public Collection getAllCallersModuleIds() {
        return this.callers.getAllCallersModuleIds();
    }

    public IvyNodeCallers.Caller[] getAllCallers() {
        return this.callers.getAllCallers();
    }

    public IvyNodeCallers.Caller[] getAllRealCallers() {
        return this.callers.getAllRealCallers();
    }

    public void addCaller(String rootModuleConf, IvyNode callerNode, String callerConf, String requestedConf, String[] dependencyConfs, DependencyDescriptor dd) {
        this.callers.addCaller(rootModuleConf, callerNode, callerConf, requestedConf, dependencyConfs, dd);
        boolean isCircular = this.callers.getAllCallersModuleIds().contains(this.getId().getModuleId());
        if (isCircular) {
            IvyContext.getContext().getCircularDependencyStrategy().handleCircularDependency(this.toMrids(this.findPath(this.getId().getModuleId()), this));
        }
    }

    public boolean doesCallersExclude(String rootModuleConf, Artifact artifact, Stack callersStack) {
        return this.callers.doesCallersExclude(rootModuleConf, artifact, callersStack);
    }

    private ModuleRevisionId[] toMrids(Collection path2, IvyNode depNode) {
        ModuleRevisionId[] ret = new ModuleRevisionId[path2.size() + 1];
        int i = 0;
        for (IvyNode node4 : path2) {
            ret[i] = node4.getId();
            ++i;
        }
        ret[ret.length - 1] = depNode.getId();
        return ret;
    }

    public Set getResolvedNodes(ModuleId moduleId, String rootModuleConf) {
        return this.eviction.getResolvedNodes(moduleId, rootModuleConf);
    }

    public Collection getResolvedRevisions(ModuleId moduleId, String rootModuleConf) {
        return this.eviction.getResolvedRevisions(moduleId, rootModuleConf);
    }

    public void markEvicted(IvyNodeEviction.EvictionData evictionData) {
        this.eviction.markEvicted(evictionData);
        String rootModuleConf = evictionData.getRootModuleConf();
        if (evictionData.getSelected() != null) {
            for (IvyNode selected : evictionData.getSelected()) {
                selected.updateDataFrom(this, rootModuleConf, false);
            }
        }
    }

    public Collection getAllEvictingConflictManagers() {
        return this.eviction.getAllEvictingConflictManagers();
    }

    public Collection getAllEvictingNodes() {
        return this.eviction.getAllEvictingNodes();
    }

    public Collection getAllEvictingNodesDetails() {
        return this.eviction.getAllEvictingNodesDetails();
    }

    public String[] getEvictedConfs() {
        return this.eviction.getEvictedConfs();
    }

    public IvyNodeEviction.EvictionData getEvictedData(String rootModuleConf) {
        return this.eviction.getEvictedData(rootModuleConf);
    }

    public Collection getEvictedNodes(ModuleId mid, String rootModuleConf) {
        return this.eviction.getEvictedNodes(mid, rootModuleConf);
    }

    public Collection getEvictedRevisions(ModuleId mid, String rootModuleConf) {
        return this.eviction.getEvictedRevisions(mid, rootModuleConf);
    }

    public IvyNodeEviction.EvictionData getEvictionDataInRoot(String rootModuleConf, IvyNode ancestor) {
        return this.eviction.getEvictionDataInRoot(rootModuleConf, ancestor);
    }

    public boolean isCompletelyEvicted() {
        return this.eviction.isCompletelyEvicted();
    }

    public boolean isEvicted(String rootModuleConf) {
        return this.eviction.isEvicted(rootModuleConf);
    }

    public void markEvicted(String rootModuleConf, IvyNode node4, ConflictManager conflictManager, Collection resolved) {
        IvyNodeEviction.EvictionData evictionData = new IvyNodeEviction.EvictionData(rootModuleConf, node4, conflictManager, resolved);
        this.markEvicted(evictionData);
    }

    public void setEvictedNodes(ModuleId moduleId, String rootModuleConf, Collection evicted) {
        this.eviction.setEvictedNodes(moduleId, rootModuleConf, evicted);
    }

    public void setResolvedNodes(ModuleId moduleId, String rootModuleConf, Collection resolved) {
        this.eviction.setResolvedNodes(moduleId, rootModuleConf, resolved);
    }

    public String toString() {
        return this.getResolvedId().toString();
    }

    public boolean equals(Object obj2) {
        if (!(obj2 instanceof IvyNode)) {
            return false;
        }
        IvyNode node4 = (IvyNode)obj2;
        return node4.getId().equals(this.getId());
    }

    public int compareTo(Object obj2) {
        IvyNode that = (IvyNode)obj2;
        return this.getModuleId().compareTo(that.getModuleId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public Collection getPendingConflicts(String rootModuleConf, ModuleId mid) {
        return this.eviction.getPendingConflicts(rootModuleConf, mid);
    }

    public void setPendingConflicts(ModuleId moduleId, String rootModuleConf, Collection conflicts) {
        this.eviction.setPendingConflicts(moduleId, rootModuleConf, conflicts);
    }

    public void blacklist(IvyNodeBlacklist bdata) {
        if (this.data.getSettings().logResolvedRevision()) {
            Message.info("BLACKLISTING " + bdata);
        } else {
            Message.verbose("BLACKLISTING " + bdata);
        }
        Stack<IvyNode> callerStack = new Stack<IvyNode>();
        callerStack.push(this);
        this.clearEvictionDataInAllCallers(bdata.getRootModuleConf(), callerStack);
        this.usage.blacklist(bdata);
        this.data.blacklist(this);
    }

    private void clearEvictionDataInAllCallers(String rootModuleConf, Stack callerStack) {
        IvyNode node4 = (IvyNode)callerStack.peek();
        IvyNodeCallers.Caller[] callers = node4.getCallers(rootModuleConf);
        for (int i = 0; i < callers.length; ++i) {
            IvyNode callerNode = this.findNode(callers[i].getModuleRevisionId());
            if (callerNode == null) continue;
            callerNode.eviction = new IvyNodeEviction(callerNode);
            if (callerStack.contains(callerNode)) continue;
            callerStack.push(callerNode);
            this.clearEvictionDataInAllCallers(rootModuleConf, callerStack);
            callerStack.pop();
        }
    }

    public boolean isBlacklisted(String rootModuleConf) {
        return this.usage.isBlacklisted(rootModuleConf);
    }

    public boolean isCompletelyBlacklisted() {
        if (this.isRoot()) {
            return false;
        }
        String[] rootModuleConfigurations = this.getRootModuleConfigurations();
        for (int i = 0; i < rootModuleConfigurations.length; ++i) {
            if (this.isBlacklisted(rootModuleConfigurations[i])) continue;
            return false;
        }
        return true;
    }

    public IvyNodeBlacklist getBlacklistData(String rootModuleConf) {
        return this.usage.getBlacklistData(rootModuleConf);
    }

    public IvyNodeUsage getMainUsage() {
        return this.usage;
    }

    public boolean hasAnyMergedUsageWithTransitiveDependency(String rootModuleConf) {
        if (this.mergedUsages == null) {
            return false;
        }
        for (IvyNodeUsage usage : this.mergedUsages.values()) {
            if (!usage.hasTransitiveDepender(rootModuleConf)) continue;
            return true;
        }
        return false;
    }
}

