/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.report;

import java.io.File;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.report.DownloadStatus;

public class ArtifactDownloadReport {
    public static final String MISSING_ARTIFACT = "missing artifact";
    private Artifact artifact;
    private ArtifactOrigin origin;
    private File localFile;
    private DownloadStatus downloadStatus;
    private long size;
    private String downloadDetails = "";
    private long downloadTimeMillis;
    private File unpackedLocalFile;

    public ArtifactDownloadReport(Artifact artifact) {
        this.artifact = artifact;
    }

    public DownloadStatus getDownloadStatus() {
        return this.downloadStatus;
    }

    public void setDownloadStatus(DownloadStatus downloadStatus) {
        this.downloadStatus = downloadStatus;
    }

    public String getName() {
        return this.artifact.getName();
    }

    public String getType() {
        return this.artifact.getType();
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public String getExt() {
        return this.artifact.getExt();
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size2) {
        this.size = size2;
    }

    public void setArtifactOrigin(ArtifactOrigin origin) {
        this.origin = origin;
    }

    public ArtifactOrigin getArtifactOrigin() {
        return this.origin;
    }

    public void setDownloadDetails(String message) {
        this.downloadDetails = message;
    }

    public String getDownloadDetails() {
        return this.downloadDetails;
    }

    public void setDownloadTimeMillis(long l) {
        this.downloadTimeMillis = l;
    }

    public long getDownloadTimeMillis() {
        return this.downloadTimeMillis;
    }

    public String toString() {
        if (this.downloadStatus == DownloadStatus.SUCCESSFUL) {
            return "[SUCCESSFUL ] " + this.artifact + " (" + this.downloadTimeMillis + "ms)";
        }
        if (this.downloadStatus == DownloadStatus.FAILED) {
            if (this.downloadDetails == MISSING_ARTIFACT) {
                return "[NOT FOUND  ] " + this.artifact + " (" + this.downloadTimeMillis + "ms)";
            }
            return "[FAILED     ] " + this.artifact + ": " + this.downloadDetails + " (" + this.downloadTimeMillis + "ms)";
        }
        if (this.downloadStatus == DownloadStatus.NO) {
            return "[NOT REQUIRED] " + this.artifact;
        }
        return super.toString();
    }

    public File getLocalFile() {
        return this.localFile;
    }

    public void setLocalFile(File localFile) {
        this.localFile = localFile;
    }

    public boolean isDownloaded() {
        return DownloadStatus.SUCCESSFUL == this.downloadStatus;
    }

    public void setUnpackedLocalFile(File unpackedLocalFile) {
        this.unpackedLocalFile = unpackedLocalFile;
    }

    public File getUnpackedLocalFile() {
        return this.unpackedLocalFile;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.artifact == null ? 0 : this.artifact.hashCode());
        return result2;
    }

    public boolean equals(Object obj2) {
        if (this == obj2) {
            return true;
        }
        if (obj2 == null) {
            return false;
        }
        if (this.getClass() != obj2.getClass()) {
            return false;
        }
        ArtifactDownloadReport other = (ArtifactDownloadReport)obj2;
        return !(this.artifact == null ? other.artifact != null : !this.artifact.equals(other.artifact));
    }
}

