/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.publish;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.event.publish.EndArtifactPublishEvent;
import org.apache.ivy.core.event.publish.StartArtifactPublishEvent;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.MDArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.publish.PublishEngineSettings;
import org.apache.ivy.core.publish.PublishOptions;
import org.apache.ivy.plugins.parser.xml.UpdateOptions;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorParser;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorUpdater;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.util.ConfigurationUtils;
import org.apache.ivy.util.Message;
import org.xml.sax.SAXException;

public class PublishEngine {
    private PublishEngineSettings settings;
    private EventManager eventManager;

    public PublishEngine(PublishEngineSettings settings, EventManager eventManager) {
        this.settings = settings;
        this.eventManager = eventManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection publish(ModuleRevisionId mrid, Collection srcArtifactPattern, String resolverName, PublishOptions options2) throws IOException {
        ModuleDescriptor md;
        long start2;
        block13: {
            Message.info(":: publishing :: " + mrid.getModuleId());
            Message.verbose("\tvalidate = " + options2.isValidate());
            start2 = System.currentTimeMillis();
            options2.setSrcIvyPattern(this.settings.substitute(options2.getSrcIvyPattern()));
            if (options2.getPubBranch() == null) {
                options2.setPubbranch(mrid.getBranch());
            }
            if (options2.getPubrevision() == null) {
                options2.setPubrevision(mrid.getRevision());
            }
            ModuleRevisionId pubmrid = ModuleRevisionId.newInstance(mrid, options2.getPubBranch(), options2.getPubrevision());
            md = null;
            if (options2.getSrcIvyPattern() != null) {
                File ivyFile = this.settings.resolveFile(IvyPatternHelper.substitute(options2.getSrcIvyPattern(), DefaultArtifact.newIvyArtifact(pubmrid, new Date())));
                if (!ivyFile.exists()) {
                    throw new IllegalArgumentException("ivy file to publish not found for " + mrid + ": call deliver before (" + ivyFile + ")");
                }
                URL ivyFileURL = ivyFile.toURI().toURL();
                try {
                    md = XmlModuleDescriptorParser.getInstance().parseDescriptor(this.settings, ivyFileURL, false);
                    if (options2.isUpdate()) {
                        File tmp = File.createTempFile("ivy", ".xml");
                        tmp.deleteOnExit();
                        String[] confs = ConfigurationUtils.replaceWildcards(options2.getConfs(), md);
                        HashSet<String> confsToRemove = new HashSet<String>(Arrays.asList(md.getConfigurationsNames()));
                        confsToRemove.removeAll(Arrays.asList(confs));
                        try {
                            XmlModuleDescriptorUpdater.update(ivyFileURL, tmp, new UpdateOptions().setSettings(this.settings).setStatus(options2.getStatus() == null ? md.getStatus() : options2.getStatus()).setRevision(options2.getPubrevision()).setBranch(options2.getPubBranch()).setPubdate(options2.getPubdate() == null ? new Date() : options2.getPubdate()).setMerge(options2.isMerge()).setMergedDescriptor(md).setConfsToExclude(confsToRemove.toArray(new String[confsToRemove.size()])));
                            ivyFile = tmp;
                            md = XmlModuleDescriptorParser.getInstance().parseDescriptor(this.settings, ivyFile.toURI().toURL(), false);
                            options2.setSrcIvyPattern(ivyFile.getAbsolutePath());
                            break block13;
                        }
                        catch (SAXException e2) {
                            throw new IllegalStateException("bad ivy file for " + mrid + ": " + ivyFile + ": " + e2);
                        }
                    }
                    if (!options2.getPubrevision().equals(md.getModuleRevisionId().getRevision())) {
                        throw new IllegalArgumentException("cannot publish " + ivyFile + " as " + options2.getPubrevision() + ": bad revision found in ivy file (Revision: " + md.getModuleRevisionId().getRevision() + "). Use forcedeliver or update.");
                    }
                    break block13;
                }
                catch (ParseException e3) {
                    throw new IllegalStateException("bad ivy file for " + mrid + ": " + ivyFile + ": " + e3);
                }
            }
            ResolutionCacheManager cacheManager = this.settings.getResolutionCacheManager();
            try {
                md = cacheManager.getResolvedModuleDescriptor(mrid);
            }
            catch (ParseException e4) {
                throw new IllegalStateException("bad ivy file in cache for " + mrid + ": " + e4);
            }
            md.setResolvedModuleRevisionId(pubmrid);
        }
        DependencyResolver resolver = this.settings.getResolver(resolverName);
        if (resolver == null) {
            throw new IllegalArgumentException("unknown resolver " + resolverName);
        }
        Collection missing = this.publish(md, srcArtifactPattern, resolver, options2);
        Message.verbose("\tpublish done (" + (System.currentTimeMillis() - start2) + "ms)");
        return missing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection publish(ModuleDescriptor md, Collection srcArtifactPattern, DependencyResolver resolver, PublishOptions options2) throws IOException {
        File artifactFile;
        ArrayList<Artifact> missing = new ArrayList<Artifact>();
        LinkedHashSet<Artifact> artifactsSet = new LinkedHashSet<Artifact>();
        String[] confs = ConfigurationUtils.replaceWildcards(options2.getConfs(), md);
        for (int i = 0; i < confs.length; ++i) {
            Artifact[] artifacts2 = md.getArtifacts(confs[i]);
            for (int j = 0; j < artifacts2.length; ++j) {
                artifactsSet.add(artifacts2[j]);
            }
        }
        Artifact[] extraArtifacts = options2.getExtraArtifacts();
        if (extraArtifacts != null) {
            for (int i = 0; i < extraArtifacts.length; ++i) {
                artifactsSet.add(new MDArtifact(md, extraArtifacts[i].getName(), extraArtifacts[i].getType(), extraArtifacts[i].getExt(), extraArtifacts[i].getUrl(), extraArtifacts[i].getQualifiedExtraAttributes()));
            }
        }
        LinkedHashMap<Artifact, File> artifactsFiles = new LinkedHashMap<Artifact, File>();
        for (Artifact artifact : artifactsSet) {
            for (String pattern2 : srcArtifactPattern) {
                artifactFile = this.settings.resolveFile(IvyPatternHelper.substitute(this.settings.substitute(pattern2), artifact));
                if (!artifactFile.exists()) continue;
                artifactsFiles.put(artifact, artifactFile);
                break;
            }
            if (artifactsFiles.containsKey(artifact)) continue;
            StringBuffer sb = new StringBuffer();
            sb.append("missing artifact " + artifact + ":\n");
            for (String pattern3 : srcArtifactPattern) {
                sb.append("\t" + this.settings.resolveFile(IvyPatternHelper.substitute(pattern3, artifact)) + " file does not exist\n");
            }
            if (options2.isWarnOnMissing() || options2.isHaltOnMissing()) {
                Message.warn(sb.toString());
            } else {
                Message.verbose(sb.toString());
            }
            if (options2.isHaltOnMissing()) {
                throw new IOException("missing artifact " + artifact);
            }
            missing.add(artifact);
        }
        if (options2.getSrcIvyPattern() != null) {
            Artifact artifact = MDArtifact.newIvyArtifact(md);
            File artifactFile2 = this.settings.resolveFile(IvyPatternHelper.substitute(options2.getSrcIvyPattern(), artifact));
            if (!artifactFile2.exists()) {
                String msg = "missing ivy file for " + md.getModuleRevisionId() + ": \n" + artifactFile2 + " file does not exist";
                if (options2.isWarnOnMissing() || options2.isHaltOnMissing()) {
                    Message.warn(msg);
                } else {
                    Message.verbose(msg);
                }
                if (options2.isHaltOnMissing()) {
                    throw new IOException("missing ivy artifact " + artifact);
                }
                missing.add(artifact);
            } else {
                artifactsFiles.put(artifact, artifactFile2);
            }
        }
        boolean successfullyPublished = false;
        try {
            resolver.beginPublishTransaction(md.getModuleRevisionId(), options2.isOverwrite());
            for (Map.Entry entry : artifactsFiles.entrySet()) {
                Artifact artifact = (Artifact)entry.getKey();
                artifactFile = (File)entry.getValue();
                this.publish(artifact, artifactFile, resolver, options2.isOverwrite());
            }
            resolver.commitPublishTransaction();
            successfullyPublished = true;
        }
        finally {
            if (!successfullyPublished) {
                resolver.abortPublishTransaction();
            }
        }
        return missing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publish(Artifact artifact, File src, DependencyResolver resolver, boolean overwrite) throws IOException {
        IvyContext.getContext().checkInterrupted();
        this.eventManager.fireIvyEvent(new StartArtifactPublishEvent(resolver, artifact, src, overwrite));
        boolean successful = false;
        try {
            if (src.exists()) {
                resolver.publish(artifact, src, overwrite);
                successful = true;
            }
        }
        finally {
            this.eventManager.fireIvyEvent(new EndArtifactPublishEvent(resolver, artifact, src, overwrite, successful));
        }
    }
}

