/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.pack;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.ivy.core.pack.ArchivePacking;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;

public class ZipPacking
extends ArchivePacking {
    private static final String[] NAMES = new String[]{"zip", "jar", "war"};

    public String[] getNames() {
        return NAMES;
    }

    public String getUnpackedExtension(String ext) {
        if ((ext.endsWith("zip") || ext.endsWith("jar") || ext.endsWith("war")) && (ext = ext.substring(0, ext.length() - 3)).endsWith(".")) {
            ext = ext.substring(0, ext.length() - 1);
        }
        return ext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpack(InputStream packed, File dest) throws IOException {
        ZipInputStream zip2 = null;
        try {
            zip2 = new ZipInputStream(packed);
            ZipEntry entry = null;
            while ((entry = zip2.getNextEntry()) != null) {
                File f2 = new File(dest, entry.getName());
                Message.verbose("\t\texpanding " + entry.getName() + " to " + f2);
                File dirF = f2.getParentFile();
                if (dirF != null) {
                    dirF.mkdirs();
                }
                if (entry.isDirectory()) {
                    f2.mkdirs();
                } else {
                    FileOutputStream out2 = new FileOutputStream(f2);
                    try {
                        FileUtil.copy(zip2, out2, null, false);
                    }
                    finally {
                        try {
                            out2.close();
                        }
                        catch (IOException e2) {}
                    }
                }
                f2.setLastModified(entry.getTime());
            }
        }
        finally {
            if (zip2 != null) {
                try {
                    zip2.close();
                }
                catch (IOException e3) {}
            }
        }
    }
}

