/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.pack;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.pack.ArchivePacking;
import org.apache.ivy.core.pack.StreamPacking;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.IvySettingsAware;

public class PackagingManager
implements IvySettingsAware {
    private IvySettings settings;

    public void setSettings(IvySettings settings) {
        this.settings = settings;
    }

    public Artifact getUnpackedArtifact(Artifact artifact) {
        String packaging = artifact.getExtraAttribute("packaging");
        if (packaging == null) {
            return null;
        }
        String ext = artifact.getExt();
        String[] packings = packaging.split(",");
        for (int i = packings.length - 1; i >= 1; --i) {
            ArchivePacking packing = this.settings.getPackingRegistry().get(packings[i]);
            if (packing == null) {
                throw new IllegalStateException("Unknown packing type '" + packings[i] + "' in the packing chain: " + packaging);
            }
            if (!(packing instanceof StreamPacking)) {
                throw new IllegalStateException("Unsupported archive only packing type '" + packings[i] + "' in the streamed chain: " + packaging);
            }
            ext = ((StreamPacking)packing).getUnpackedExtension(ext);
        }
        ArchivePacking packing = this.settings.getPackingRegistry().get(packings[0]);
        if (packing == null) {
            throw new IllegalStateException("Unknown packing type '" + packings[0] + "' in the packing chain: " + packaging);
        }
        ext = packing.getUnpackedExtension(ext);
        DefaultArtifact unpacked = new DefaultArtifact(artifact.getModuleRevisionId(), artifact.getPublicationDate(), artifact.getName(), artifact.getType() + "_unpacked", ext);
        return unpacked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpackArtifact(Artifact artifact, File localFile, File archiveFile) throws IOException {
        String packaging = artifact.getExtraAttribute("packaging");
        if (packaging == null) {
            return;
        }
        String[] packings = packaging.split(",");
        InputStream in2 = null;
        try {
            in2 = new FileInputStream(localFile);
            for (int i = packings.length - 1; i >= 1; --i) {
                ArchivePacking packing = this.settings.getPackingRegistry().get(packings[i]);
                if (packing == null) {
                    throw new IllegalStateException("Unknown packing type '" + packings[i] + "' in the packing chain: " + packaging);
                }
                if (!(packing instanceof StreamPacking)) {
                    throw new IllegalStateException("Unsupported archive only packing type '" + packings[i] + "' in the streamed chain: " + packaging);
                }
                in2 = ((StreamPacking)packing).unpack(in2);
            }
            ArchivePacking packing = this.settings.getPackingRegistry().get(packings[0]);
            if (packing == null) {
                throw new IllegalStateException("Unknown packing type '" + packings[0] + "' in the packing chain: " + packaging);
            }
            packing.unpack(in2, archiveFile);
        }
        finally {
            if (in2 != null) {
                try {
                    in2.close();
                }
                catch (IOException e2) {}
            }
        }
    }
}

