/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.pack;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;
import org.apache.ivy.core.pack.StreamPacking;

public class Pack200Packing
extends StreamPacking {
    private static final String[] NAMES = new String[]{"pack200"};

    public String[] getNames() {
        return NAMES;
    }

    public String getUnpackedExtension(String ext) {
        if (ext.endsWith("pack.gz")) {
            if ((ext = ext.substring(0, ext.length() - 7)).endsWith(".")) {
                ext = ext.substring(0, ext.length() - 1);
            }
        } else if (ext.endsWith("pack") && (ext = ext.substring(0, ext.length() - 4)).endsWith(".")) {
            ext = ext.substring(0, ext.length() - 1);
        }
        return ext;
    }

    public InputStream unpack(InputStream packed) throws IOException {
        BufferedInputStream buffered = new BufferedInputStream(packed);
        buffered.mark(4);
        byte[] magic = new byte[4];
        buffered.read(magic, 0, 4);
        buffered.reset();
        FilterInputStream in2 = buffered;
        if (magic[0] == 31 && magic[1] == -117 && magic[2] == 8) {
            in2 = new GZIPInputStream(in2);
        }
        Pack200.Unpacker unpacker = Pack200.newUnpacker();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JarOutputStream jar = new JarOutputStream(baos);
        unpacker.unpack((InputStream)in2, jar);
        jar.close();
        return new ByteArrayInputStream(baos.toByteArray());
    }
}

