/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.descriptor;

import java.util.ArrayList;
import java.util.List;
import org.apache.ivy.core.module.descriptor.ExtendsDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;

public class DefaultExtendsDescriptor
implements ExtendsDescriptor {
    private ModuleDescriptor parent;
    private String location;
    private List extendsTypes;
    private boolean local;

    public DefaultExtendsDescriptor(ModuleDescriptor parent2, String location, String[] types) {
        this(parent2, location, types, false);
    }

    public DefaultExtendsDescriptor(ModuleDescriptor parent2, String location, String[] types, boolean local2) {
        this.parent = parent2;
        this.location = location;
        this.local = local2;
        this.extendsTypes = new ArrayList(types.length);
        for (int i = 0; i < types.length; ++i) {
            this.extendsTypes.add(types[i]);
        }
    }

    public ModuleRevisionId getParentRevisionId() {
        return this.parent.getModuleRevisionId();
    }

    public ModuleRevisionId getResolvedParentRevisionId() {
        return this.parent.getResolvedModuleRevisionId();
    }

    public ModuleDescriptor getParentMd() {
        return this.parent;
    }

    public String getLocation() {
        return this.location;
    }

    public String[] getExtendsTypes() {
        return this.extendsTypes.toArray(new String[this.extendsTypes.size()]);
    }

    public boolean isAllInherited() {
        return this.extendsTypes.contains("all");
    }

    public boolean isInfoInherited() {
        return this.isAllInherited() || this.extendsTypes.contains("info");
    }

    public boolean isDescriptionInherited() {
        return this.isAllInherited() || this.extendsTypes.contains("description");
    }

    public boolean areConfigurationsInherited() {
        return this.isAllInherited() || this.extendsTypes.contains("configurations");
    }

    public boolean areDependenciesInherited() {
        return this.isAllInherited() || this.extendsTypes.contains("dependencies");
    }

    public boolean isLocal() {
        return this.local;
    }
}

