/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.install;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.install.InstallEngineSettings;
import org.apache.ivy.core.install.InstallOptions;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.MetadataArtifactDownloadReport;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.DownloadOptions;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.ResolveEngine;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.search.SearchEngine;
import org.apache.ivy.plugins.conflict.NoConflictManager;
import org.apache.ivy.plugins.matcher.ExactPatternMatcher;
import org.apache.ivy.plugins.matcher.MatcherHelper;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.util.Message;

public class InstallEngine {
    private InstallEngineSettings settings;
    private ResolveEngine resolveEngine;
    private SearchEngine searchEngine;

    public InstallEngine(InstallEngineSettings settings, SearchEngine searchEngine, ResolveEngine resolveEngine) {
        this.settings = settings;
        this.searchEngine = searchEngine;
        this.resolveEngine = resolveEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResolveReport install(ModuleRevisionId mrid, String from2, String to2, InstallOptions options2) throws IOException {
        DependencyResolver fromResolver = this.settings.getResolver(from2);
        DependencyResolver toResolver = this.settings.getResolver(to2);
        if (fromResolver == null) {
            throw new IllegalArgumentException("unknown resolver " + from2 + ". Available resolvers are: " + this.settings.getResolverNames());
        }
        if (toResolver == null) {
            throw new IllegalArgumentException("unknown resolver " + to2 + ". Available resolvers are: " + this.settings.getResolverNames());
        }
        PatternMatcher matcher = this.settings.getMatcher(options2.getMatcherName());
        if (matcher == null) {
            throw new IllegalArgumentException("unknown matcher " + options2.getMatcherName() + ". Available matchers are: " + this.settings.getMatcherNames());
        }
        Message.info(":: installing " + mrid + " ::");
        DependencyResolver oldDicator = this.resolveEngine.getDictatorResolver();
        boolean log = this.settings.logNotConvertedExclusionRule();
        try {
            this.settings.setLogNotConvertedExclusionRule(true);
            this.resolveEngine.setDictatorResolver(fromResolver);
            DefaultModuleDescriptor md = new DefaultModuleDescriptor(ModuleRevisionId.newInstance("apache", "ivy-install", "1.0"), this.settings.getStatusManager().getDefaultStatus(), new Date());
            String resolveId = ResolveOptions.getDefaultResolveId(md);
            md.addConfiguration(new Configuration("default"));
            md.addConflictManager(new ModuleId("*", "*"), ExactPatternMatcher.INSTANCE, new NoConflictManager());
            for (int c2 = 0; c2 < options2.getConfs().length; ++c2) {
                String[] depConfs = options2.getConfs();
                for (int j = 0; j < depConfs.length; ++j) {
                    String depConf = depConfs[j].trim();
                    if (MatcherHelper.isExact(matcher, mrid)) {
                        DefaultDependencyDescriptor dd = new DefaultDependencyDescriptor(md, mrid, false, false, options2.isTransitive());
                        dd.addDependencyConfiguration("default", depConf);
                        md.addDependency(dd);
                        continue;
                    }
                    ModuleRevisionId[] mrids = this.searchEngine.listModules(fromResolver, mrid, matcher);
                    for (int i = 0; i < mrids.length; ++i) {
                        Message.info("\tfound " + mrids[i] + " to install: adding to the list");
                        DefaultDependencyDescriptor dd = new DefaultDependencyDescriptor(md, mrids[i], false, false, options2.isTransitive());
                        dd.addDependencyConfiguration("default", depConf);
                        md.addDependency(dd);
                    }
                }
            }
            ResolveReport report = new ResolveReport(md, resolveId);
            Message.info(":: resolving dependencies ::");
            ResolveOptions resolveOptions = new ResolveOptions().setResolveId(resolveId).setConfs(new String[]{"default"}).setValidate(options2.isValidate());
            IvyNode[] dependencies2 = this.resolveEngine.getDependencies(md, resolveOptions, report);
            report.setDependencies(Arrays.asList(dependencies2), options2.getArtifactFilter());
            Message.info(":: downloading artifacts to cache ::");
            this.resolveEngine.downloadArtifacts(report, options2.getArtifactFilter(), new DownloadOptions());
            Message.info(":: installing in " + to2 + " ::");
            for (int i = 0; i < dependencies2.length; ++i) {
                ModuleDescriptor depmd = dependencies2[i].getDescriptor();
                if (depmd == null) continue;
                ModuleRevisionId depMrid = depmd.getModuleRevisionId();
                Message.verbose("installing " + depMrid);
                boolean successfullyPublished = false;
                try {
                    toResolver.beginPublishTransaction(depMrid, options2.isOverwrite());
                    ArtifactDownloadReport[] artifacts2 = report.getArtifactsReports(depMrid);
                    for (int j = 0; j < artifacts2.length; ++j) {
                        if (artifacts2[j].getLocalFile() == null) continue;
                        toResolver.publish(artifacts2[j].getArtifact(), artifacts2[j].getLocalFile(), options2.isOverwrite());
                    }
                    MetadataArtifactDownloadReport artifactDownloadReport = dependencies2[i].getModuleRevision().getReport();
                    File localIvyFile = artifactDownloadReport.getLocalFile();
                    toResolver.publish(depmd.getMetadataArtifact(), localIvyFile, options2.isOverwrite());
                    if (options2.isInstallOriginalMetadata() && artifactDownloadReport.getArtifactOrigin() != null && artifactDownloadReport.getArtifactOrigin().isExists() && !ArtifactOrigin.isUnknown(artifactDownloadReport.getArtifactOrigin()) && artifactDownloadReport.getArtifactOrigin().getArtifact() != null && artifactDownloadReport.getArtifactOrigin().getArtifact().getType().endsWith(".original") && !artifactDownloadReport.getArtifactOrigin().getArtifact().getType().equals(depmd.getMetadataArtifact().getType() + ".original")) {
                        toResolver.publish(artifactDownloadReport.getArtifactOrigin().getArtifact(), artifactDownloadReport.getOriginalLocalFile(), options2.isOverwrite());
                    }
                    toResolver.commitPublishTransaction();
                    successfullyPublished = true;
                    continue;
                }
                finally {
                    if (!successfullyPublished) {
                        toResolver.abortPublishTransaction();
                    }
                }
            }
            Message.info(":: install resolution report ::");
            this.resolveEngine.outputReport(report, this.settings.getResolutionCacheManager(), resolveOptions);
            ResolveReport resolveReport = report;
            return resolveReport;
        }
        finally {
            Message.sumupProblems();
            this.resolveEngine.setDictatorResolver(oldDicator);
            this.settings.setLogNotConvertedExclusionRule(log);
        }
    }
}

