/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.event;

import org.apache.ivy.core.event.IvyEvent;
import org.apache.ivy.plugins.matcher.ExactPatternMatcher;
import org.apache.ivy.plugins.matcher.Matcher;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.util.filter.AndFilter;
import org.apache.ivy.util.filter.Filter;
import org.apache.ivy.util.filter.NoFilter;
import org.apache.ivy.util.filter.NotFilter;
import org.apache.ivy.util.filter.OrFilter;

public class IvyEventFilter
implements Filter {
    private static final String NOT = "NOT ";
    private static final String OR = " OR ";
    private static final String AND = " AND ";
    private PatternMatcher matcher;
    private Filter nameFilter;
    private Filter attFilter;

    public IvyEventFilter(String event, String filterExpression, PatternMatcher matcher) {
        PatternMatcher patternMatcher = this.matcher = matcher == null ? ExactPatternMatcher.INSTANCE : matcher;
        if (event == null) {
            this.nameFilter = NoFilter.INSTANCE;
        } else {
            final Matcher eventNameMatcher = this.matcher.getMatcher(event);
            this.nameFilter = new Filter(){

                public boolean accept(Object o) {
                    IvyEvent e2 = (IvyEvent)o;
                    return eventNameMatcher.matches(e2.getName());
                }
            };
        }
        this.attFilter = filterExpression == null || filterExpression.trim().length() == 0 ? NoFilter.INSTANCE : this.parseExpression(filterExpression);
    }

    private Filter parseExpression(String filterExpression) {
        int index2 = (filterExpression = filterExpression.trim()).indexOf(AND);
        if (index2 == -1) {
            index2 = filterExpression.indexOf(OR);
            if (index2 == -1) {
                if (filterExpression.startsWith(NOT)) {
                    return new NotFilter(this.parseExpression(filterExpression.substring(NOT.length())));
                }
                index2 = filterExpression.indexOf("=");
                if (index2 == -1) {
                    throw new IllegalArgumentException("bad filter expression: " + filterExpression + ": no equal sign found");
                }
                final String attname = filterExpression.substring(0, index2).trim();
                String[] values2 = filterExpression.substring(index2 + 1).trim().split(",");
                final Matcher[] matchers = new Matcher[values2.length];
                for (int i = 0; i < values2.length; ++i) {
                    matchers[i] = this.matcher.getMatcher(values2[i].trim());
                }
                return new Filter(){

                    public boolean accept(Object o) {
                        IvyEvent e2 = (IvyEvent)o;
                        String val = (String)e2.getAttributes().get(attname);
                        if (val == null) {
                            return false;
                        }
                        for (int i = 0; i < matchers.length; ++i) {
                            if (!matchers[i].matches(val)) continue;
                            return true;
                        }
                        return false;
                    }
                };
            }
            return new OrFilter(this.parseExpression(filterExpression.substring(0, index2)), this.parseExpression(filterExpression.substring(index2 + OR.length())));
        }
        return new AndFilter(this.parseExpression(filterExpression.substring(0, index2)), this.parseExpression(filterExpression.substring(index2 + AND.length())));
    }

    public boolean accept(Object o) {
        if (!(o instanceof IvyEvent)) {
            return false;
        }
        return this.nameFilter.accept(o) && this.attFilter.accept(o);
    }
}

