/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.event;

import java.util.HashMap;
import java.util.Map;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.util.StringUtils;

public class IvyEvent {
    private EventManager source;
    private String name;
    private Map attributes = new HashMap();

    protected IvyEvent(String name) {
        this.source = IvyContext.getContext().getEventManager();
        this.name = name;
    }

    protected void addAttribute(String key, String value2) {
        this.attributes.put(key, value2);
    }

    protected void addMDAttributes(ModuleDescriptor md) {
        this.addMridAttributes(md.getResolvedModuleRevisionId());
    }

    protected void addMridAttributes(ModuleRevisionId mrid) {
        this.addModuleIdAttributes(mrid.getModuleId());
        this.addAttribute("revision", mrid.getRevision());
        this.addAttribute("branch", mrid.getBranch());
        this.addAttributes(mrid.getQualifiedExtraAttributes());
        this.addAttributes(mrid.getExtraAttributes());
    }

    protected void addModuleIdAttributes(ModuleId moduleId) {
        this.addAttribute("organisation", moduleId.getOrganisation());
        this.addAttribute("module", moduleId.getName());
    }

    protected void addConfsAttribute(String[] confs) {
        this.addAttribute("conf", StringUtils.join(confs, ", "));
    }

    protected void addAttributes(Map attributes) {
        this.attributes.putAll(attributes);
    }

    public EventManager getSource() {
        return this.source;
    }

    public String getName() {
        return this.name;
    }

    public Map getAttributes() {
        return new HashMap(this.attributes);
    }

    public String toString() {
        return this.getName() + " " + this.getAttributes();
    }

    public boolean equals(Object obj2) {
        if (!(obj2 instanceof IvyEvent)) {
            return false;
        }
        IvyEvent e2 = (IvyEvent)obj2;
        return this.getSource().equals(e2.getSource()) && this.getName().equals(e2.getName()) && ((Object)this.attributes).equals(e2.attributes);
    }

    public int hashCode() {
        int hash2 = 37;
        hash2 = 13 * hash2 + this.getSource().hashCode();
        hash2 = 13 * hash2 + this.getName().hashCode();
        hash2 = 13 * hash2 + ((Object)this.attributes).hashCode();
        return hash2;
    }
}

