/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ivy.ant.IvyTask;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.plugins.parser.m2.PomModuleDescriptorWriter;
import org.apache.ivy.plugins.parser.m2.PomWriterOptions;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorParser;
import org.apache.ivy.util.FileUtil;
import org.apache.tools.ant.BuildException;

public class IvyMakePom
extends IvyTask {
    private String artifactName;
    private String artifactPackaging;
    private File pomFile = null;
    private File headerFile = null;
    private File templateFile = null;
    private boolean printIvyInfo = true;
    private String conf;
    private File ivyFile = null;
    private String description;
    private Collection mappings = new ArrayList();
    private Collection dependencies = new ArrayList();

    public File getPomFile() {
        return this.pomFile;
    }

    public void setPomFile(File file2) {
        this.pomFile = file2;
    }

    public File getIvyFile() {
        return this.ivyFile;
    }

    public void setIvyFile(File ivyFile) {
        this.ivyFile = ivyFile;
    }

    public File getHeaderFile() {
        return this.headerFile;
    }

    public void setHeaderFile(File headerFile) {
        this.headerFile = headerFile;
    }

    public File getTemplateFile() {
        return this.templateFile;
    }

    public void setTemplateFile(File templateFile) {
        this.templateFile = templateFile;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isPrintIvyInfo() {
        return this.printIvyInfo;
    }

    public void setPrintIvyInfo(boolean printIvyInfo) {
        this.printIvyInfo = printIvyInfo;
    }

    public String getConf() {
        return this.conf;
    }

    public void setConf(String conf) {
        this.conf = conf;
    }

    public String getArtifactName() {
        return this.artifactName;
    }

    public void setArtifactName(String artifactName) {
        this.artifactName = artifactName;
    }

    public String getArtifactPackaging() {
        return this.artifactPackaging;
    }

    public void setArtifactPackaging(String artifactPackaging) {
        this.artifactPackaging = artifactPackaging;
    }

    public Mapping createMapping() {
        Mapping mapping = new Mapping();
        this.mappings.add(mapping);
        return mapping;
    }

    public Dependency createDependency() {
        Dependency dependency2 = new Dependency();
        this.dependencies.add(dependency2);
        return dependency2;
    }

    public void doExecute() throws BuildException {
        try {
            if (this.ivyFile == null) {
                throw new BuildException("source ivy file is required for makepom task");
            }
            if (this.pomFile == null) {
                throw new BuildException("destination pom file is required for makepom task");
            }
            ModuleDescriptor md = XmlModuleDescriptorParser.getInstance().parseDescriptor(this.getSettings(), this.ivyFile.toURI().toURL(), false);
            PomModuleDescriptorWriter.write(md, this.pomFile, this.getPomWriterOptions());
        }
        catch (MalformedURLException e2) {
            throw new BuildException("unable to convert given ivy file to url: " + this.ivyFile + ": " + e2, (Throwable)e2);
        }
        catch (ParseException e3) {
            this.log(e3.getMessage(), 0);
            throw new BuildException("syntax errors in ivy file " + this.ivyFile + ": " + e3, (Throwable)e3);
        }
        catch (Exception e4) {
            throw new BuildException("impossible convert given ivy file to pom file: " + e4 + " from=" + this.ivyFile + " to=" + this.pomFile, (Throwable)e4);
        }
    }

    private PomWriterOptions getPomWriterOptions() throws IOException {
        PomWriterOptions options2 = new PomWriterOptions();
        options2.setConfs(this.splitConfs(this.conf)).setArtifactName(this.getArtifactName()).setArtifactPackaging(this.getArtifactPackaging()).setPrintIvyInfo(this.isPrintIvyInfo()).setDescription(this.getDescription()).setExtraDependencies(this.getDependencies()).setTemplate(this.getTemplateFile());
        if (!this.mappings.isEmpty()) {
            options2.setMapping(new PomWriterOptions.ConfigurationScopeMapping(this.getMappingsMap()));
        }
        if (this.headerFile != null) {
            options2.setLicenseHeader(FileUtil.readEntirely(this.getHeaderFile()));
        }
        return options2;
    }

    private Map getMappingsMap() {
        HashMap<String, String> mappingsMap = new HashMap<String, String>();
        for (Mapping mapping : this.mappings) {
            String[] mappingConfs = this.splitConfs(mapping.getConf());
            for (int i = 0; i < mappingConfs.length; ++i) {
                if (mappingsMap.containsKey(mappingConfs[i])) continue;
                mappingsMap.put(mappingConfs[i], mapping.getScope());
            }
        }
        return mappingsMap;
    }

    private List getDependencies() {
        ArrayList<PomWriterOptions.ExtraDependency> result2 = new ArrayList<PomWriterOptions.ExtraDependency>();
        for (Dependency dependency2 : this.dependencies) {
            result2.add(new PomWriterOptions.ExtraDependency(dependency2.getGroup(), dependency2.getArtifact(), dependency2.getVersion(), dependency2.getScope(), dependency2.getType(), dependency2.getClassifier(), dependency2.getOptional()));
        }
        return result2;
    }

    public class Dependency {
        private String group = null;
        private String artifact = null;
        private String version = null;
        private String scope = null;
        private String type = null;
        private String classifier = null;
        private boolean optional = false;

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public String getArtifact() {
            return this.artifact;
        }

        public void setArtifact(String artifact) {
            this.artifact = artifact;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version2) {
            this.version = version2;
        }

        public String getScope() {
            return this.scope;
        }

        public void setScope(String scope2) {
            this.scope = scope2;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public void setClassifier(String classifier) {
            this.classifier = classifier;
        }

        public boolean getOptional() {
            return this.optional;
        }

        public void setOptional(boolean optional2) {
            this.optional = optional2;
        }
    }

    public class Mapping {
        private String conf;
        private String scope;

        public String getConf() {
            return this.conf;
        }

        public void setConf(String conf) {
            this.conf = conf;
        }

        public String getScope() {
            return this.scope;
        }

        public void setScope(String scope2) {
            this.scope = scope2;
        }
    }
}

