/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.ivy.Ivy;
import org.apache.ivy.ant.IvyTask;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.apache.tools.ant.BuildException;

public class IvyInfo
extends IvyTask {
    private File file = null;
    private String organisation;
    private String module;
    private String branch;
    private String revision;
    private String property = "ivy";

    public File getFile() {
        return this.file;
    }

    public void setFile(File file2) {
        this.file = file2;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module2) {
        this.module = module2;
    }

    public String getOrganisation() {
        return this.organisation;
    }

    public void setOrganisation(String organisation) {
        this.organisation = organisation;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String prefix) {
        this.property = prefix;
    }

    public void doExecute() throws BuildException {
        Ivy ivy = this.getIvyInstance();
        IvySettings settings = ivy.getSettings();
        try {
            if (this.organisation != null || this.module != null || this.revision != null || this.branch != null) {
                ResolvedModuleRevision rmr;
                if (this.organisation == null) {
                    throw new BuildException("no organisation provided for ivy info task");
                }
                if (this.module == null) {
                    throw new BuildException("no module name provided for ivy info task");
                }
                if (this.revision == null) {
                    throw new BuildException("no revision provided for ivy info task");
                }
                if (this.branch == null) {
                    settings.getDefaultBranch(new ModuleId(this.organisation, this.module));
                }
                if ((rmr = ivy.findModule(ModuleRevisionId.newInstance(this.organisation, this.module, this.branch, this.revision))) != null) {
                    ModuleDescriptor md = rmr.getDescriptor();
                    ModuleRevisionId mrid = rmr.getId();
                    this.setProperties(md, mrid);
                }
            } else {
                if (this.file == null) {
                    this.file = this.getProject().resolveFile(this.getProperty(settings, "ivy.dep.file"));
                }
                ModuleDescriptor md = ModuleDescriptorParserRegistry.getInstance().parseDescriptor(settings, this.file.toURI().toURL(), this.doValidate(settings));
                ModuleRevisionId mrid = md.getModuleRevisionId();
                this.setProperties(md, mrid);
            }
        }
        catch (MalformedURLException e2) {
            throw new BuildException("unable to convert given ivy file to url: " + this.file + ": " + e2, (Throwable)e2);
        }
        catch (ParseException e3) {
            this.log(e3.getMessage(), 0);
            throw new BuildException("syntax errors in ivy file: " + e3, (Throwable)e3);
        }
        catch (Exception e4) {
            throw new BuildException("impossible to resolve dependencies: " + e4, (Throwable)e4);
        }
    }

    private void setProperties(ModuleDescriptor md, ModuleRevisionId mrid) {
        this.getProject().setProperty(this.property + ".organisation", mrid.getOrganisation());
        this.getProject().setProperty(this.property + ".module", mrid.getName());
        if (mrid.getBranch() != null) {
            this.getProject().setProperty(this.property + ".branch", mrid.getBranch());
        }
        this.getProject().setProperty(this.property + ".revision", mrid.getRevision());
        this.getProject().setProperty(this.property + ".status", md.getStatus());
        if (md.getPublicationDate() != null) {
            this.getProject().setProperty(this.property + ".publication", Long.toString(md.getPublicationDate().getTime()));
        }
        Map extra = mrid.getExtraAttributes();
        for (Map.Entry entry : extra.entrySet()) {
            this.getProject().setProperty(this.property + ".extra." + entry.getKey(), (String)entry.getValue());
        }
        this.getProject().setProperty(this.property + ".configurations", this.mergeConfs(md.getConfigurationsNames()));
        Configuration[] configs = md.getConfigurations();
        ArrayList<String> publicConfigsList = new ArrayList<String>();
        for (int i = 0; i < configs.length; ++i) {
            String name = configs[i].getName();
            if (Configuration.Visibility.PUBLIC.equals(configs[i].getVisibility())) {
                publicConfigsList.add(name);
            }
            if (configs[i].getDescription() == null) continue;
            this.getProject().setProperty(this.property + ".configuration." + name + ".desc", configs[i].getDescription());
        }
        String[] publicConfigs = publicConfigsList.toArray(new String[publicConfigsList.size()]);
        this.getProject().setProperty(this.property + ".public.configurations", this.mergeConfs(publicConfigs));
        Artifact[] artifacts2 = md.getAllArtifacts();
        for (int i = 0; i < artifacts2.length; ++i) {
            int id2 = i + 1;
            this.getProject().setProperty(this.property + ".artifact." + id2 + ".name", artifacts2[i].getName());
            this.getProject().setProperty(this.property + ".artifact." + id2 + ".type", artifacts2[i].getType());
            this.getProject().setProperty(this.property + ".artifact." + id2 + ".ext", artifacts2[i].getExt());
            this.getProject().setProperty(this.property + ".artifact." + id2 + ".conf", this.mergeConfs(artifacts2[i].getConfigurations()));
            Map artiExtra = artifacts2[i].getExtraAttributes();
            for (Map.Entry entry : artiExtra.entrySet()) {
                this.getProject().setProperty(this.property + ".artifact." + id2 + ".extra." + entry.getKey(), (String)entry.getValue());
            }
        }
    }
}

