/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ivy.ant.IvyPostResolveTask;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.IvyNodeCallers;
import org.apache.ivy.core.resolve.IvyNodeEviction;
import org.apache.tools.ant.BuildException;

public class IvyDependencyTree
extends IvyPostResolveTask {
    private Map dependencies = new HashMap();
    private boolean showEvicted = false;

    public void doExecute() throws BuildException {
        this.prepareAndCheck();
        ResolveReport report = this.getResolvedReport();
        this.log("Dependency tree for " + report.getResolveId());
        ModuleRevisionId mrid = report.getModuleDescriptor().getModuleRevisionId();
        for (IvyNode dependency2 : report.getDependencies()) {
            this.populateDependencyTree(dependency2, mrid, report);
        }
        this.printDependencies((List)this.dependencies.get(mrid), 0);
    }

    private void printDependencies(List dependencyList, int indent) {
        Iterator iterator2 = dependencyList.iterator();
        while (iterator2.hasNext()) {
            IvyNode dependency2 = (IvyNode)iterator2.next();
            boolean evicted = dependency2.isEvicted(this.getConf());
            if (evicted && !this.showEvicted) continue;
            StringBuffer sb = new StringBuffer();
            if (indent > 0) {
                for (int i = 0; i < indent; ++i) {
                    if (i == indent - 1 && !iterator2.hasNext() && !this.hasDependencies(dependency2)) {
                        sb.append("   ");
                        continue;
                    }
                    sb.append("|  ");
                }
            }
            if (iterator2.hasNext()) {
                sb.append("+- ");
            } else {
                sb.append("\\- ");
            }
            sb.append(dependency2.getId().toString());
            if (evicted && this.showEvicted) {
                IvyNodeEviction.EvictionData evictedData = dependency2.getEvictedData(this.getConf());
                if (evictedData.isTransitivelyEvicted()) {
                    sb.append(" transitively");
                } else {
                    sb.append(" evicted by ");
                    sb.append(evictedData.getSelected());
                    sb.append(" in ").append(evictedData.getParent());
                    if (evictedData.getDetail() != null) {
                        sb.append(" ").append(evictedData.getDetail());
                    }
                }
            }
            this.log(sb.toString());
            this.printDependencies((List)this.dependencies.get(dependency2.getId()), indent + 1);
        }
    }

    private boolean hasDependencies(IvyNode dependency2) {
        List dependencyList = (List)this.dependencies.get(dependency2.getId());
        return dependencyList.size() > 0;
    }

    private void populateDependencyTree(IvyNode dependency2, ModuleRevisionId currentMrid, ResolveReport report) {
        this.registerNodeIfNecessary(dependency2.getId());
        for (int i = 0; i < dependency2.getAllCallers().length; ++i) {
            IvyNodeCallers.Caller caller = dependency2.getAllCallers()[i];
            this.addDependency(caller.getModuleRevisionId(), dependency2);
        }
    }

    private void registerNodeIfNecessary(ModuleRevisionId moduleRevisionId) {
        if (!this.dependencies.containsKey(moduleRevisionId)) {
            this.dependencies.put(moduleRevisionId, new ArrayList());
        }
    }

    private void addDependency(ModuleRevisionId moduleRevisionId, IvyNode dependency2) {
        this.registerNodeIfNecessary(moduleRevisionId);
        List list2 = (List)this.dependencies.get(moduleRevisionId);
        list2.add(dependency2);
    }

    public boolean isShowEvicted() {
        return this.showEvicted;
    }

    public void setShowEvicted(boolean showEvicted) {
        this.showEvicted = showEvicted;
    }
}

