/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import java.util.List;
import org.apache.ivy.ant.IvyCacheTask;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.ManifestParser;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Path;

public class IvyCachePath
extends IvyCacheTask {
    private String pathid;
    private String id;
    private boolean osgi = false;

    public String getPathid() {
        return this.pathid;
    }

    public void setPathid(String id2) {
        this.pathid = id2;
    }

    public void setOsgi(boolean osgi) {
        this.osgi = osgi;
    }

    @Deprecated
    public void setId(String id2) {
        this.id = id2;
    }

    public void doExecute() throws BuildException {
        this.prepareAndCheck();
        if (this.pathid == null) {
            if (this.id != null) {
                this.pathid = this.id;
                this.log("ID IS DEPRECATED, PLEASE USE PATHID INSTEAD", 1);
            } else {
                throw new BuildException("pathid is required in ivy classpath");
            }
        }
        try {
            Path path2 = new Path(this.getProject());
            this.getProject().addReference(this.pathid, (Object)path2);
            for (ArtifactDownloadReport a2 : this.getArtifactReports()) {
                File f2 = a2.getLocalFile();
                if (a2.getUnpackedLocalFile() != null) {
                    f2 = a2.getUnpackedLocalFile();
                }
                this.addToPath(path2, f2);
            }
        }
        catch (Exception ex) {
            throw new BuildException("impossible to build ivy path: " + ex, (Throwable)ex);
        }
    }

    protected void addToPath(Path path2, File f2) throws Exception {
        if (!this.osgi || !f2.isDirectory()) {
            path2.createPathElement().setLocation(f2);
            return;
        }
        File manifest = new File(f2, "META-INF/MANIFEST.MF");
        if (!manifest.exists()) {
            path2.createPathElement().setLocation(f2);
            return;
        }
        BundleInfo bundleInfo = ManifestParser.parseManifest(manifest);
        List<String> cp = bundleInfo.getClasspath();
        if (cp == null) {
            path2.createPathElement().setLocation(f2);
            return;
        }
        for (int i = 0; i < cp.size(); ++i) {
            String p = cp.get(i);
            if (p.equals(".")) {
                path2.createPathElement().setLocation(f2);
                continue;
            }
            path2.createPathElement().setLocation(new File(f2, p));
        }
    }
}

