/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.ivy.ant.IvyCacheTask;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;

public class IvyCacheFileset
extends IvyCacheTask {
    private String setid;

    public String getSetid() {
        return this.setid;
    }

    public void setSetid(String id2) {
        this.setid = id2;
    }

    public void setUseOrigin(boolean useOrigin) {
        if (useOrigin) {
            throw new UnsupportedOperationException("the cachefileset task does not support the useOrigin mode, since filesets require to have only one root directory. Please use the the cachepath task instead");
        }
    }

    public void doExecute() throws BuildException {
        this.prepareAndCheck();
        if (this.setid == null) {
            throw new BuildException("setid is required in ivy cachefileset");
        }
        try {
            FileSet fileset;
            List<ArtifactDownloadReport> paths = this.getArtifactReports();
            File base = null;
            for (ArtifactDownloadReport a2 : paths) {
                if (a2.getLocalFile() == null) continue;
                base = this.getBaseDir(base, a2.getLocalFile());
            }
            if (base == null) {
                fileset = new EmptyFileSet();
            } else {
                fileset = new FileSet();
                fileset.setDir(base);
                for (ArtifactDownloadReport a3 : paths) {
                    if (a3.getLocalFile() == null) continue;
                    PatternSet.NameEntry ne = fileset.createInclude();
                    ne.setName(this.getPath(base, a3.getLocalFile()));
                }
            }
            fileset.setProject(this.getProject());
            this.getProject().addReference(this.setid, (Object)fileset);
        }
        catch (Exception ex) {
            throw new BuildException("impossible to build ivy cache fileset: " + ex, (Throwable)ex);
        }
    }

    private String getPath(File base, File file2) {
        String absoluteBasePath = base.getAbsolutePath();
        int beginIndex = absoluteBasePath.length();
        if (!absoluteBasePath.endsWith(File.separator)) {
            ++beginIndex;
        }
        return file2.getAbsolutePath().substring(beginIndex);
    }

    File getBaseDir(File base, File file2) {
        File next2;
        if (base == null) {
            return file2.getParentFile().getAbsoluteFile();
        }
        Iterator bases = this.getParents(base).iterator();
        Iterator fileParents = this.getParents(file2.getAbsoluteFile()).iterator();
        File result2 = null;
        while (bases.hasNext() && fileParents.hasNext() && (next2 = (File)bases.next()).equals(fileParents.next())) {
            result2 = next2;
        }
        return result2;
    }

    private LinkedList getParents(File file2) {
        LinkedList<File> r = new LinkedList<File>();
        while (file2 != null) {
            r.addFirst(file2);
            file2 = file2.getParentFile();
        }
        return r;
    }

    private static class EmptyDirectoryScanner
    extends DirectoryScanner {
        private EmptyDirectoryScanner() {
        }

        public String[] getIncludedFiles() {
            return new String[0];
        }
    }

    private static class EmptyIterator
    implements Iterator {
        private EmptyIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException("EmptyFileSet Iterator");
        }

        public void remove() {
            throw new IllegalStateException("EmptyFileSet Iterator");
        }
    }

    private static class EmptyFileSet
    extends FileSet {
        private DirectoryScanner ds = new EmptyDirectoryScanner();

        private EmptyFileSet() {
        }

        public Iterator iterator() {
            return new EmptyIterator();
        }

        public Object clone() {
            return new EmptyFileSet();
        }

        public int size() {
            return 0;
        }

        public DirectoryScanner getDirectoryScanner(Project project2) {
            return this.ds;
        }
    }
}

