/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.ivy.ant.IvyPostResolveTask;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.cache.RepositoryCacheManager;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.core.retrieve.RetrieveOptions;
import org.apache.tools.ant.BuildException;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class IvyArtifactReport
extends IvyPostResolveTask {
    private File tofile;
    private String pattern;

    public File getTofile() {
        return this.tofile;
    }

    public void setTofile(File aFile) {
        this.tofile = aFile;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String aPattern) {
        this.pattern = aPattern;
    }

    public void doExecute() throws BuildException {
        this.prepareAndCheck();
        if (this.tofile == null) {
            throw new BuildException("no destination file name: please provide it through parameter 'tofile'");
        }
        this.pattern = this.getProperty(this.pattern, this.getSettings(), "ivy.retrieve.pattern");
        try {
            String[] confs = this.splitConfs(this.getConf());
            ModuleDescriptor md = null;
            md = this.getResolveId() != null ? (ModuleDescriptor)this.getResolvedDescriptor(this.getResolveId()) : (ModuleDescriptor)this.getResolvedDescriptor(this.getOrganisation(), this.getModule(), false);
            IvyNode[] dependencies2 = this.getIvyInstance().getResolveEngine().getDependencies(md, ((ResolveOptions)new ResolveOptions().setLog(this.getLog())).setConfs(confs).setResolveId(this.getResolveId()).setValidate(this.doValidate(this.getSettings())), null);
            Map artifactsToCopy = this.getIvyInstance().getRetrieveEngine().determineArtifactsToCopy(ModuleRevisionId.newInstance(this.getOrganisation(), this.getModule(), this.getRevision()), this.pattern, ((RetrieveOptions)new RetrieveOptions().setLog(this.getLog())).setConfs(confs).setResolveId(this.getResolveId()));
            HashMap<ModuleRevisionId, HashSet<ArtifactDownloadReport>> moduleRevToArtifactsMap = new HashMap<ModuleRevisionId, HashSet<ArtifactDownloadReport>>();
            for (ArtifactDownloadReport artifact : artifactsToCopy.keySet()) {
                HashSet<ArtifactDownloadReport> moduleRevArtifacts = (HashSet<ArtifactDownloadReport>)moduleRevToArtifactsMap.get(artifact.getArtifact().getModuleRevisionId());
                if (moduleRevArtifacts == null) {
                    moduleRevArtifacts = new HashSet<ArtifactDownloadReport>();
                    moduleRevToArtifactsMap.put(artifact.getArtifact().getModuleRevisionId(), moduleRevArtifacts);
                }
                moduleRevArtifacts.add(artifact);
            }
            this.generateXml(dependencies2, moduleRevToArtifactsMap, artifactsToCopy);
        }
        catch (ParseException e2) {
            this.log(e2.getMessage(), 0);
            throw new BuildException("syntax errors in ivy file: " + e2, (Throwable)e2);
        }
        catch (IOException e3) {
            throw new BuildException("impossible to generate report: " + e3, (Throwable)e3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateXml(IvyNode[] dependencies2, Map moduleRevToArtifactsMap, Map artifactsToCopy) {
        try {
            FileOutputStream fileOuputStream = new FileOutputStream(this.tofile);
            try {
                TransformerHandler saxHandler = this.createTransformerHandler(fileOuputStream);
                saxHandler.startDocument();
                saxHandler.startElement(null, "modules", "modules", new AttributesImpl());
                for (int i = 0; i < dependencies2.length; ++i) {
                    IvyNode dependency2 = dependencies2[i];
                    if (dependency2.getModuleRevision() == null || dependency2.isCompletelyEvicted()) continue;
                    this.startModule(saxHandler, dependency2);
                    Set artifactsOfModuleRev = (Set)moduleRevToArtifactsMap.get(dependency2.getModuleRevision().getId());
                    if (artifactsOfModuleRev != null) {
                        for (ArtifactDownloadReport artifact : artifactsOfModuleRev) {
                            RepositoryCacheManager cache = dependency2.getModuleRevision().getArtifactResolver().getRepositoryCacheManager();
                            this.startArtifact(saxHandler, artifact.getArtifact());
                            this.writeOriginLocationIfPresent(cache, saxHandler, artifact);
                            this.writeCacheLocationIfPresent(cache, saxHandler, artifact);
                            Set artifactDestPaths = (Set)artifactsToCopy.get(artifact);
                            for (String artifactDestPath : artifactDestPaths) {
                                this.writeRetrieveLocation(saxHandler, artifactDestPath);
                            }
                            saxHandler.endElement(null, "artifact", "artifact");
                        }
                    }
                    saxHandler.endElement(null, "module", "module");
                }
                saxHandler.endElement(null, "modules", "modules");
                saxHandler.endDocument();
            }
            finally {
                fileOuputStream.close();
            }
        }
        catch (SAXException e2) {
            throw new BuildException("impossible to generate report", (Throwable)e2);
        }
        catch (TransformerConfigurationException e3) {
            throw new BuildException("impossible to generate report", (Throwable)e3);
        }
        catch (IOException e4) {
            throw new BuildException("impossible to generate report", (Throwable)e4);
        }
    }

    private TransformerHandler createTransformerHandler(FileOutputStream fileOuputStream) throws TransformerFactoryConfigurationError, TransformerConfigurationException, SAXException {
        SAXTransformerFactory transformerFact = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler saxHandler = transformerFact.newTransformerHandler();
        saxHandler.getTransformer().setOutputProperty("encoding", "UTF-8");
        saxHandler.getTransformer().setOutputProperty("indent", "yes");
        saxHandler.setResult(new StreamResult(fileOuputStream));
        return saxHandler;
    }

    private void startModule(TransformerHandler saxHandler, IvyNode dependency2) throws SAXException {
        AttributesImpl moduleAttrs = new AttributesImpl();
        moduleAttrs.addAttribute(null, "organisation", "organisation", "CDATA", dependency2.getModuleId().getOrganisation());
        moduleAttrs.addAttribute(null, "name", "name", "CDATA", dependency2.getModuleId().getName());
        ResolvedModuleRevision moduleRevision = dependency2.getModuleRevision();
        moduleAttrs.addAttribute(null, "rev", "rev", "CDATA", moduleRevision.getId().getRevision());
        moduleAttrs.addAttribute(null, "status", "status", "CDATA", moduleRevision.getDescriptor().getStatus());
        saxHandler.startElement(null, "module", "module", moduleAttrs);
    }

    private void startArtifact(TransformerHandler saxHandler, Artifact artifact) throws SAXException {
        AttributesImpl artifactAttrs = new AttributesImpl();
        artifactAttrs.addAttribute(null, "name", "name", "CDATA", artifact.getName());
        artifactAttrs.addAttribute(null, "ext", "ext", "CDATA", artifact.getExt());
        artifactAttrs.addAttribute(null, "type", "type", "CDATA", artifact.getType());
        saxHandler.startElement(null, "artifact", "artifact", artifactAttrs);
    }

    private void writeOriginLocationIfPresent(RepositoryCacheManager cache, TransformerHandler saxHandler, ArtifactDownloadReport artifact) throws IOException, SAXException {
        ArtifactOrigin origin = artifact.getArtifactOrigin();
        if (!ArtifactOrigin.isUnknown(origin)) {
            String originLocation;
            String originName = origin.getLocation();
            boolean isOriginLocal = origin.isLocal();
            AttributesImpl originLocationAttrs = new AttributesImpl();
            if (isOriginLocal) {
                originLocationAttrs.addAttribute(null, "is-local", "is-local", "CDATA", "true");
                originLocation = originName.replace('\\', '/');
            } else {
                originLocationAttrs.addAttribute(null, "is-local", "is-local", "CDATA", "false");
                originLocation = originName;
            }
            saxHandler.startElement(null, "origin-location", "origin-location", originLocationAttrs);
            char[] originLocationAsChars = originLocation.toCharArray();
            saxHandler.characters(originLocationAsChars, 0, originLocationAsChars.length);
            saxHandler.endElement(null, "origin-location", "origin-location");
        }
    }

    private void writeCacheLocationIfPresent(RepositoryCacheManager cache, TransformerHandler saxHandler, ArtifactDownloadReport artifact) throws SAXException {
        File archiveInCache = artifact.getLocalFile();
        if (archiveInCache != null) {
            saxHandler.startElement(null, "cache-location", "cache-location", new AttributesImpl());
            char[] archiveInCacheAsChars = archiveInCache.getPath().replace('\\', '/').toCharArray();
            saxHandler.characters(archiveInCacheAsChars, 0, archiveInCacheAsChars.length);
            saxHandler.endElement(null, "cache-location", "cache-location");
        }
    }

    private void writeRetrieveLocation(TransformerHandler saxHandler, String artifactDestPath) throws SAXException {
        artifactDestPath = this.removeLeadingPath(this.getProject().getBaseDir(), new File(artifactDestPath));
        saxHandler.startElement(null, "retrieve-location", "retrieve-location", new AttributesImpl());
        char[] artifactDestPathAsChars = artifactDestPath.replace('\\', '/').toCharArray();
        saxHandler.characters(artifactDestPathAsChars, 0, artifactDestPathAsChars.length);
        saxHandler.endElement(null, "retrieve-location", "retrieve-location");
    }

    public String removeLeadingPath(File leading, File path2) {
        String p;
        String l = leading.getAbsolutePath();
        if (l.equals(p = path2.getAbsolutePath())) {
            return "";
        }
        if (!l.endsWith(File.separator)) {
            l = l + File.separator;
        }
        return p.startsWith(l) ? p.substring(l.length()) : p;
    }
}

