/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import org.apache.ivy.ant.IvyPostResolveTask;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.plugins.report.XmlReportParser;
import org.apache.tools.ant.BuildException;

public class IvyArtifactProperty
extends IvyPostResolveTask {
    private String name;
    private String value;
    private boolean overwrite = false;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value2) {
        this.value = value2;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void doExecute() throws BuildException {
        this.prepareAndCheck();
        try {
            ResolutionCacheManager cacheMgr = this.getIvyInstance().getResolutionCacheManager();
            String[] confs = this.splitConfs(this.getConf());
            String resolveId = this.getResolveId();
            if (resolveId == null) {
                resolveId = ResolveOptions.getDefaultResolveId(this.getResolvedModuleId());
            }
            XmlReportParser parser2 = new XmlReportParser();
            for (int i = 0; i < confs.length; ++i) {
                File report = cacheMgr.getConfigurationResolveReportInCache(resolveId, confs[i]);
                parser2.parse(report);
                Artifact[] artifacts2 = parser2.getArtifacts();
                for (int j = 0; j < artifacts2.length; ++j) {
                    Artifact artifact = artifacts2[j];
                    String name = IvyPatternHelper.substitute(this.getSettings().substitute(this.getName()), artifact, confs[i]);
                    String value2 = IvyPatternHelper.substitute(this.getSettings().substitute(this.getValue()), artifact, confs[i]);
                    this.setProperty(name, value2);
                }
            }
        }
        catch (Exception ex) {
            throw new BuildException("impossible to add artifact properties: " + ex, (Throwable)ex);
        }
    }

    private void setProperty(String name, String value2) {
        if (this.overwrite) {
            this.getProject().setProperty(name, value2);
        } else {
            this.getProject().setNewProperty(name, value2);
        }
    }
}

