/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.util.HashMap;
import java.util.Map;
import org.apache.ivy.core.settings.IvyVariableContainer;
import org.apache.ivy.core.settings.IvyVariableContainerImpl;
import org.apache.ivy.util.Message;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Property;

class IvyAntVariableContainer
extends IvyVariableContainerImpl
implements IvyVariableContainer {
    private Map overwrittenProperties = new HashMap();
    private Project project;

    public IvyAntVariableContainer(Project project2) {
        this.project = project2;
    }

    public String getVariable(String name) {
        String r = (String)this.overwrittenProperties.get(name);
        if (r == null) {
            r = this.project.getProperty(name);
        }
        if (r == null) {
            r = super.getVariable(name);
        }
        return r;
    }

    public void setVariable(String varName, String value2, boolean overwrite) {
        if (overwrite) {
            Message.debug("setting '" + varName + "' to '" + value2 + "'");
            this.overwrittenProperties.put(varName, this.substitute(value2));
        } else {
            super.setVariable(varName, value2, overwrite);
        }
    }

    public void updateProject(String id2) {
        HashMap r = new HashMap(super.getVariables());
        r.putAll(this.overwrittenProperties);
        for (Map.Entry entry : r.entrySet()) {
            this.setPropertyIfNotSet((String)entry.getKey(), (String)entry.getValue());
            if (id2 == null) continue;
            this.setPropertyIfNotSet((String)entry.getKey() + "." + id2, (String)entry.getValue());
        }
        if (this.getEnvironmentPrefix() != null) {
            Property propTask = new Property();
            propTask.setProject(this.project);
            propTask.setEnvironment(this.getEnvironmentPrefix());
            propTask.init();
            propTask.execute();
        }
    }

    private void setPropertyIfNotSet(String property, String value2) {
        if (this.project.getProperty(property) == null) {
            this.project.setProperty(property, value2);
        }
    }

    public Object clone() {
        IvyAntVariableContainer result2 = (IvyAntVariableContainer)super.clone();
        result2.overwrittenProperties = (HashMap)((HashMap)this.overwrittenProperties).clone();
        return result2;
    }
}

