/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec.util;

public class DebugUtils {
    public static final String COMMONS_EXEC_LENIENT = "org.apache.commons.exec.lenient";
    public static final String COMMONS_EXEC_DEBUG = "org.apache.commons.exec.debug";

    public static void handleException(String msg, Exception e2) {
        if (DebugUtils.isDebugEnabled()) {
            System.err.println(msg);
            e2.printStackTrace();
        }
        if (!DebugUtils.isLenientEnabled()) {
            if (e2 instanceof RuntimeException) {
                throw (RuntimeException)e2;
            }
            throw new RuntimeException(e2.getMessage());
        }
    }

    public static boolean isDebugEnabled() {
        String debug = System.getProperty(COMMONS_EXEC_DEBUG, Boolean.FALSE.toString());
        return Boolean.TRUE.toString().equalsIgnoreCase(debug);
    }

    public static boolean isLenientEnabled() {
        String lenient = System.getProperty(COMMONS_EXEC_LENIENT, Boolean.TRUE.toString());
        return Boolean.TRUE.toString().equalsIgnoreCase(lenient);
    }
}

