/*
 * Decompiled with CFR 0.152.
 */
package joptsimple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import joptsimple.UnrecognizedOptionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OptionException
extends RuntimeException {
    private static final long serialVersionUID = -1L;
    private final List<String> options = new ArrayList<String>();

    protected OptionException(Collection<String> options2) {
        this.options.addAll(options2);
    }

    protected OptionException(Collection<String> options2, Throwable cause) {
        super(cause);
        this.options.addAll(options2);
    }

    public Collection<String> options() {
        return Collections.unmodifiableCollection(this.options);
    }

    protected final String singleOptionMessage() {
        return this.singleOptionMessage(this.options.get(0));
    }

    protected final String singleOptionMessage(String option2) {
        return "'" + option2 + "'";
    }

    protected final String multipleOptionMessage() {
        StringBuilder buffer2 = new StringBuilder("[");
        Iterator<String> iter = this.options.iterator();
        while (iter.hasNext()) {
            buffer2.append(this.singleOptionMessage(iter.next()));
            if (!iter.hasNext()) continue;
            buffer2.append(", ");
        }
        buffer2.append(']');
        return buffer2.toString();
    }

    static OptionException unrecognizedOption(String option2) {
        return new UnrecognizedOptionException(option2);
    }
}

