/*
 * Decompiled with CFR 0.152.
 */
package grizzled.net;

import grizzled.net.IPAddress;
import java.net.InetAddress;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.RichInt$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class IPAddress$ {
    public static final IPAddress$ MODULE$;
    private final Try<IPAddress> Localhost;
    private final BigInt MaxIPv4;
    private final Regex IPv6Pattern;
    private final Regex IPv4Pattern;

    static {
        new IPAddress$();
    }

    public final Try<IPAddress> Localhost() {
        return this.Localhost;
    }

    private BigInt MaxIPv4() {
        return this.MaxIPv4;
    }

    private Regex IPv6Pattern() {
        return this.IPv6Pattern;
    }

    private Regex IPv4Pattern() {
        return this.IPv4Pattern;
    }

    public Try<IPAddress> apply(byte[] addr) {
        return this.apply((List<Object>)Predef$.MODULE$.byteArrayOps(addr).toList());
    }

    public Try<IPAddress> apply(int[] addr) {
        return this.apply((byte[])Predef$.MODULE$.intArrayOps(addr).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte apply(int x$1) {
                return (byte)x$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte())));
    }

    public Try<IPAddress> apply(Seq<Object> addr) {
        return this.apply((List<Object>)((TraversableOnce)addr.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte apply(int x$2) {
                return (byte)x$2;
            }
        }, Seq$.MODULE$.canBuildFrom())).toList());
    }

    public Try<IPAddress> apply(List<Object> address) {
        Failure failure2;
        byte zeroByte = (byte)0;
        int n = address.length();
        switch (n) {
            default: {
                if (n > 16) {
                    failure2 = new Failure((Throwable)new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IP address ", " is too long."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{address.mkString(".")}))));
                    break;
                }
                int upper = n < 4 ? 4 : 16;
                failure2 = new Success(address.$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(n), upper).map((Function1)new Serializable(zeroByte){
                    public static final long serialVersionUID = 0L;
                    private final byte zeroByte$1;

                    public final byte apply(int x$3) {
                        return this.zeroByte$1;
                    }
                    {
                        this.zeroByte$1 = zeroByte$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom()));
                break;
            }
            case 0: {
                failure2 = new Failure((Throwable)new IllegalArgumentException("Empty IP address."));
                break;
            }
            case 16: {
                failure2 = new Success(address);
                break;
            }
            case 4: {
                failure2 = new Success(address);
            }
        }
        Failure fullAddressRes = failure2;
        return fullAddressRes.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final IPAddress apply(List<Object> bytes) {
                return new IPAddress((byte[])bytes.toArray(ClassTag$.MODULE$.Byte()));
            }
        });
    }

    public IPAddress apply(InetAddress inetAddress) {
        return new IPAddress(inetAddress.getAddress());
    }

    public Try<IPAddress> apply(String host) {
        return Try$.MODULE$.apply((Function0)new Serializable(host){
            public static final long serialVersionUID = 0L;
            private final String host$1;

            public final byte[] apply() {
                return InetAddress.getByName(this.host$1).getAddress();
            }
            {
                this.host$1 = host$1;
            }
        }).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Try<IPAddress> apply(byte[] x$4) {
                return IPAddress$.MODULE$.apply(x$4);
            }
        });
    }

    public Try<IPAddress> apply(BigInt address) {
        Try<IPAddress> try_;
        if (address.$less$eq(this.MaxIPv4())) {
            byte[] bytes = new byte[]{address.$greater$greater(24).$amp(BigInt$.MODULE$.int2bigInt(255)).toByte(), address.$greater$greater(16).$amp(BigInt$.MODULE$.int2bigInt(255)).toByte(), address.$greater$greater(8).$amp(BigInt$.MODULE$.int2bigInt(255)).toByte(), address.$amp(BigInt$.MODULE$.int2bigInt(255)).toByte()};
            try_ = this.apply(bytes);
        } else {
            try_ = this.apply(address.toByteArray());
        }
        return try_;
    }

    public Try<IPAddress> parseAddress(String addressString) {
        Failure failure2;
        String string2 = addressString;
        Option option2 = this.IPv4Pattern().unapplySeq((CharSequence)string2);
        if (option2.isEmpty()) {
            Option option3 = this.IPv6Pattern().unapplySeq((CharSequence)string2);
            if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(1) >= 0) {
                String a2 = (String)((LinearSeqOptimized)option3.get()).apply(0);
                failure2 = this.apply(a2);
            } else {
                failure2 = new Failure((Throwable)new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid IP address: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{addressString}))));
            }
        } else {
            failure2 = this.apply(addressString);
        }
        return failure2;
    }

    public Try<List<IPAddress>> allForName(String hostname) {
        List list2;
        block4: {
            Try try_;
            block3: {
                List res;
                block2: {
                    res = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])InetAddress.getAllByName(hostname)).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Try<IPAddress> apply(InetAddress x) {
                            return IPAddress$.MODULE$.apply(x.getAddress());
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Try.class)))).toList();
                    list2 = (List)res.filter((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Try<IPAddress> x$5) {
                            return x$5.isFailure();
                        }
                    });
                    if (!(list2 instanceof .colon.colon)) break block2;
                    .colon.colon colon2 = (.colon.colon)list2;
                    Try failure2 = (Try)colon2.head();
                    try_ = Try$.MODULE$.apply((Function0)new Serializable(failure2){
                        public static final long serialVersionUID = 0L;
                        private final Try failure$1;

                        public final List<IPAddress> apply() {
                            return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IPAddress[]{(IPAddress)this.failure$1.get()}));
                        }
                        {
                            this.failure$1 = failure$1;
                        }
                    });
                    break block3;
                }
                if (!Nil$.MODULE$.equals(list2)) break block4;
                try_ = new Success(res.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final IPAddress apply(Try<IPAddress> x$6) {
                        return (IPAddress)x$6.get();
                    }
                }, List$.MODULE$.canBuildFrom()));
            }
            return try_;
        }
        throw new MatchError((Object)list2);
    }

    private IPAddress$() {
        MODULE$ = this;
        this.Localhost = this.apply(new int[]{127, 0, 0, 1});
        this.MaxIPv4 = package$.MODULE$.BigInt().apply("4294967295");
        this.IPv6Pattern = new StringOps(Predef$.MODULE$.augmentString("^(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))(%.*)?$")).r();
        this.IPv4Pattern = new StringOps(Predef$.MODULE$.augmentString("^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$")).r();
    }
}

