/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigIncludeContext;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigSyntax;
import com.typesafe.config.impl.AbstractConfigNode;
import com.typesafe.config.impl.AbstractConfigNodeValue;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigConcatenation;
import com.typesafe.config.impl.ConfigNodeArray;
import com.typesafe.config.impl.ConfigNodeComment;
import com.typesafe.config.impl.ConfigNodeComplexValue;
import com.typesafe.config.impl.ConfigNodeConcatenation;
import com.typesafe.config.impl.ConfigNodeField;
import com.typesafe.config.impl.ConfigNodeInclude;
import com.typesafe.config.impl.ConfigNodeObject;
import com.typesafe.config.impl.ConfigNodeRoot;
import com.typesafe.config.impl.ConfigNodeSimpleValue;
import com.typesafe.config.impl.ConfigNodeSingleToken;
import com.typesafe.config.impl.ConfigReference;
import com.typesafe.config.impl.FullIncluder;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.SimpleConfigList;
import com.typesafe.config.impl.SimpleConfigObject;
import com.typesafe.config.impl.SimpleConfigOrigin;
import com.typesafe.config.impl.SimpleIncluder;
import com.typesafe.config.impl.SubstitutionExpression;
import com.typesafe.config.impl.Token;
import com.typesafe.config.impl.Tokens;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

final class ConfigParser {
    ConfigParser() {
    }

    static AbstractConfigValue parse(ConfigNodeRoot document, ConfigOrigin origin, ConfigParseOptions options2, ConfigIncludeContext includeContext) {
        ParseContext context = new ParseContext(options2.getSyntax(), origin, document, SimpleIncluder.makeFull(options2.getIncluder()), includeContext);
        return context.parse();
    }

    private static final class ParseContext {
        private int lineNumber = 1;
        private final ConfigNodeRoot document;
        private final FullIncluder includer;
        private final ConfigIncludeContext includeContext;
        private final ConfigSyntax flavor;
        private final ConfigOrigin baseOrigin;
        private final LinkedList<Path> pathStack;
        int arrayCount;

        ParseContext(ConfigSyntax flavor, ConfigOrigin origin, ConfigNodeRoot document, FullIncluder includer, ConfigIncludeContext includeContext) {
            this.document = document;
            this.flavor = flavor;
            this.baseOrigin = origin;
            this.includer = includer;
            this.includeContext = includeContext;
            this.pathStack = new LinkedList();
            this.arrayCount = 0;
        }

        private AbstractConfigValue parseConcatenation(ConfigNodeConcatenation n) {
            if (this.flavor == ConfigSyntax.JSON) {
                throw new ConfigException.BugOrBroken("Found a concatenation node in JSON");
            }
            ArrayList<AbstractConfigValue> values2 = new ArrayList<AbstractConfigValue>();
            for (AbstractConfigNode node4 : n.children()) {
                AbstractConfigValue v2 = null;
                if (!(node4 instanceof AbstractConfigNodeValue)) continue;
                v2 = this.parseValue((AbstractConfigNodeValue)node4, null);
                values2.add(v2);
            }
            return ConfigConcatenation.concatenate(values2);
        }

        private SimpleConfigOrigin lineOrigin() {
            return ((SimpleConfigOrigin)this.baseOrigin).withLineNumber(this.lineNumber);
        }

        private ConfigException parseError(String message) {
            return this.parseError(message, null);
        }

        private ConfigException parseError(String message, Throwable cause) {
            return new ConfigException.Parse(this.lineOrigin(), message, cause);
        }

        private Path fullCurrentPath() {
            if (this.pathStack.isEmpty()) {
                throw new ConfigException.BugOrBroken("Bug in parser; tried to get current path when at root");
            }
            return new Path(this.pathStack.descendingIterator());
        }

        private AbstractConfigValue parseValue(AbstractConfigNodeValue n, List<String> comments) {
            AbstractConfigValue v2;
            int startingArrayCount = this.arrayCount;
            if (n instanceof ConfigNodeSimpleValue) {
                v2 = ((ConfigNodeSimpleValue)n).value();
            } else if (n instanceof ConfigNodeObject) {
                v2 = this.parseObject((ConfigNodeObject)n);
            } else if (n instanceof ConfigNodeArray) {
                v2 = this.parseArray((ConfigNodeArray)n);
            } else if (n instanceof ConfigNodeConcatenation) {
                v2 = this.parseConcatenation((ConfigNodeConcatenation)n);
            } else {
                throw this.parseError("Expecting a value but got wrong node type: " + n.getClass());
            }
            if (comments != null && !comments.isEmpty()) {
                v2 = v2.withOrigin(v2.origin().prependComments(new ArrayList<String>(comments)));
                comments.clear();
            }
            if (this.arrayCount != startingArrayCount) {
                throw new ConfigException.BugOrBroken("Bug in config parser: unbalanced array count");
            }
            return v2;
        }

        private static AbstractConfigObject createValueUnderPath(Path path2, AbstractConfigValue value2) {
            ArrayList<String> keys2 = new ArrayList<String>();
            String key = path2.first();
            Path remaining = path2.remainder();
            while (key != null) {
                keys2.add(key);
                if (remaining == null) break;
                key = remaining.first();
                remaining = remaining.remainder();
            }
            ListIterator i = keys2.listIterator(keys2.size());
            String deepest = (String)i.previous();
            SimpleConfigObject o = new SimpleConfigObject(value2.origin().withComments((List)null), Collections.singletonMap(deepest, value2));
            while (i.hasPrevious()) {
                Map<String, AbstractConfigValue> m = Collections.singletonMap(i.previous(), o);
                o = new SimpleConfigObject(value2.origin().withComments((List)null), m);
            }
            return o;
        }

        private void parseInclude(Map<String, AbstractConfigValue> values2, ConfigNodeInclude n) {
            AbstractConfigObject obj2;
            switch (n.kind()) {
                case URL: {
                    URL url;
                    try {
                        url = new URL(n.name());
                    }
                    catch (MalformedURLException e2) {
                        throw this.parseError("include url() specifies an invalid URL: " + n.name(), e2);
                    }
                    obj2 = (AbstractConfigObject)this.includer.includeURL(this.includeContext, url);
                    break;
                }
                case FILE: {
                    obj2 = (AbstractConfigObject)this.includer.includeFile(this.includeContext, new File(n.name()));
                    break;
                }
                case CLASSPATH: {
                    obj2 = (AbstractConfigObject)this.includer.includeResources(this.includeContext, n.name());
                    break;
                }
                case HEURISTIC: {
                    obj2 = (AbstractConfigObject)this.includer.include(this.includeContext, n.name());
                    break;
                }
                default: {
                    throw new ConfigException.BugOrBroken("should not be reached");
                }
            }
            if (this.arrayCount > 0 && obj2.resolveStatus() != ResolveStatus.RESOLVED) {
                throw this.parseError("Due to current limitations of the config parser, when an include statement is nested inside a list value, ${} substitutions inside the included file cannot be resolved correctly. Either move the include outside of the list value or remove the ${} statements from the included file.");
            }
            if (!this.pathStack.isEmpty()) {
                Path prefix = this.fullCurrentPath();
                obj2 = obj2.relativized(prefix);
            }
            for (String key : obj2.keySet()) {
                AbstractConfigValue v2 = obj2.get(key);
                AbstractConfigValue existing = values2.get(key);
                if (existing != null) {
                    values2.put(key, v2.withFallback(existing));
                    continue;
                }
                values2.put(key, v2);
            }
        }

        private AbstractConfigObject parseObject(ConfigNodeObject n) {
            HashMap<String, AbstractConfigValue> values2 = new HashMap<String, AbstractConfigValue>();
            SimpleConfigOrigin objectOrigin = this.lineOrigin();
            boolean lastWasNewline = false;
            ArrayList<AbstractConfigNode> nodes = new ArrayList<AbstractConfigNode>(n.children());
            ArrayList<String> comments = new ArrayList<String>();
            for (int i = 0; i < nodes.size(); ++i) {
                AbstractConfigNode node4 = nodes.get(i);
                if (node4 instanceof ConfigNodeComment) {
                    lastWasNewline = false;
                    comments.add(((ConfigNodeComment)node4).commentText());
                    continue;
                }
                if (node4 instanceof ConfigNodeSingleToken && Tokens.isNewline(((ConfigNodeSingleToken)node4).token())) {
                    ++this.lineNumber;
                    if (lastWasNewline) {
                        comments.clear();
                    }
                    lastWasNewline = true;
                    continue;
                }
                if (this.flavor != ConfigSyntax.JSON && node4 instanceof ConfigNodeInclude) {
                    this.parseInclude(values2, (ConfigNodeInclude)node4);
                    lastWasNewline = false;
                    continue;
                }
                if (!(node4 instanceof ConfigNodeField)) continue;
                lastWasNewline = false;
                Path path2 = ((ConfigNodeField)node4).path().value();
                comments.addAll(((ConfigNodeField)node4).comments());
                this.pathStack.push(path2);
                if (((ConfigNodeField)node4).separator() == Tokens.PLUS_EQUALS) {
                    if (this.arrayCount > 0) {
                        throw this.parseError("Due to current limitations of the config parser, += does not work nested inside a list. += expands to a ${} substitution and the path in ${} cannot currently refer to list elements. You might be able to move the += outside of the list and then refer to it from inside the list with ${}.");
                    }
                    ++this.arrayCount;
                }
                AbstractConfigNodeValue valueNode = ((ConfigNodeField)node4).value();
                AbstractConfigValue newValue = this.parseValue(valueNode, comments);
                if (((ConfigNodeField)node4).separator() == Tokens.PLUS_EQUALS) {
                    --this.arrayCount;
                    ArrayList<AbstractConfigValue> concat2 = new ArrayList<AbstractConfigValue>(2);
                    ConfigReference previousRef = new ConfigReference(newValue.origin(), new SubstitutionExpression(this.fullCurrentPath(), true));
                    SimpleConfigList list2 = new SimpleConfigList(newValue.origin(), Collections.singletonList(newValue));
                    concat2.add(previousRef);
                    concat2.add(list2);
                    newValue = ConfigConcatenation.concatenate(concat2);
                }
                if (i < nodes.size() - 1) {
                    ++i;
                    while (i < nodes.size()) {
                        if (nodes.get(i) instanceof ConfigNodeComment) {
                            ConfigNodeComment comment = (ConfigNodeComment)nodes.get(i);
                            newValue = newValue.withOrigin(newValue.origin().appendComments(Collections.singletonList(comment.commentText())));
                            break;
                        }
                        if (nodes.get(i) instanceof ConfigNodeSingleToken) {
                            ConfigNodeSingleToken curr = (ConfigNodeSingleToken)nodes.get(i);
                            if (curr.token() != Tokens.COMMA && !Tokens.isIgnoredWhitespace(curr.token())) {
                                --i;
                                break;
                            }
                        } else {
                            --i;
                            break;
                        }
                        ++i;
                    }
                }
                this.pathStack.pop();
                String key = path2.first();
                Path remaining = path2.remainder();
                if (remaining == null) {
                    AbstractConfigValue existing = (AbstractConfigValue)values2.get(key);
                    if (existing != null) {
                        if (this.flavor == ConfigSyntax.JSON) {
                            throw this.parseError("JSON does not allow duplicate fields: '" + key + "' was already seen at " + existing.origin().description());
                        }
                        newValue = newValue.withFallback(existing);
                    }
                    values2.put(key, newValue);
                    continue;
                }
                if (this.flavor == ConfigSyntax.JSON) {
                    throw new ConfigException.BugOrBroken("somehow got multi-element path in JSON mode");
                }
                AbstractConfigObject obj2 = ParseContext.createValueUnderPath(remaining, newValue);
                AbstractConfigValue existing = (AbstractConfigValue)values2.get(key);
                if (existing != null) {
                    obj2 = obj2.withFallback(existing);
                }
                values2.put(key, obj2);
            }
            return new SimpleConfigObject(objectOrigin, values2);
        }

        private SimpleConfigList parseArray(ConfigNodeArray n) {
            ++this.arrayCount;
            SimpleConfigOrigin arrayOrigin = this.lineOrigin();
            ArrayList<AbstractConfigValue> values2 = new ArrayList<AbstractConfigValue>();
            boolean lastWasNewLine = false;
            ArrayList<String> comments = new ArrayList<String>();
            AbstractConfigValue v2 = null;
            for (AbstractConfigNode node4 : n.children()) {
                if (node4 instanceof ConfigNodeComment) {
                    comments.add(((ConfigNodeComment)node4).commentText());
                    lastWasNewLine = false;
                    continue;
                }
                if (node4 instanceof ConfigNodeSingleToken && Tokens.isNewline(((ConfigNodeSingleToken)node4).token())) {
                    ++this.lineNumber;
                    if (lastWasNewLine && v2 == null) {
                        comments.clear();
                    } else if (v2 != null) {
                        values2.add(v2.withOrigin(v2.origin().appendComments(new ArrayList<String>(comments))));
                        comments.clear();
                        v2 = null;
                    }
                    lastWasNewLine = true;
                    continue;
                }
                if (!(node4 instanceof AbstractConfigNodeValue)) continue;
                lastWasNewLine = false;
                if (v2 != null) {
                    values2.add(v2.withOrigin(v2.origin().appendComments(new ArrayList<String>(comments))));
                    comments.clear();
                }
                v2 = this.parseValue((AbstractConfigNodeValue)node4, comments);
            }
            if (v2 != null) {
                values2.add(v2.withOrigin(v2.origin().appendComments(new ArrayList<String>(comments))));
            }
            --this.arrayCount;
            return new SimpleConfigList(arrayOrigin, values2);
        }

        AbstractConfigValue parse() {
            AbstractConfigValue result2 = null;
            ArrayList<String> comments = new ArrayList<String>();
            boolean lastWasNewLine = false;
            for (AbstractConfigNode node4 : this.document.children()) {
                if (node4 instanceof ConfigNodeComment) {
                    comments.add(((ConfigNodeComment)node4).commentText());
                    lastWasNewLine = false;
                    continue;
                }
                if (node4 instanceof ConfigNodeSingleToken) {
                    Token t = ((ConfigNodeSingleToken)node4).token();
                    if (!Tokens.isNewline(t)) continue;
                    ++this.lineNumber;
                    if (lastWasNewLine && result2 == null) {
                        comments.clear();
                    } else if (result2 != null) {
                        result2 = result2.withOrigin(result2.origin().appendComments(new ArrayList<String>(comments)));
                        comments.clear();
                        break;
                    }
                    lastWasNewLine = true;
                    continue;
                }
                if (!(node4 instanceof ConfigNodeComplexValue)) continue;
                result2 = this.parseValue((ConfigNodeComplexValue)node4, comments);
                lastWasNewLine = false;
            }
            return result2;
        }
    }
}

