/*
 * Decompiled with CFR 0.152.
 */
package akka.actor;

import akka.actor.ActorPath;
import akka.actor.ActorPathExtractor$;
import akka.actor.Address;
import akka.actor.InvalidActorNameException;
import akka.actor.RootActorPath;
import akka.actor.RootActorPath$;
import java.net.MalformedURLException;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class ActorPath$
implements Serializable {
    public static final ActorPath$ MODULE$;
    private final Regex ElementRegex;
    private final String ValidSymbols;
    private final int ValidPathCode;
    private final int EmptyPathCode;
    private final Iterable<String> emptyActorPath;

    static {
        new ActorPath$();
    }

    public ActorPath fromString(String s) {
        String string2 = s;
        Option<Tuple2<Address, Iterable<String>>> option2 = ActorPathExtractor$.MODULE$.unapply(string2);
        if (option2.isEmpty()) {
            throw new MalformedURLException(new StringBuilder().append((Object)"cannot parse as ActorPath: ").append((Object)s).toString());
        }
        Address addr = (Address)((Tuple2)option2.get())._1();
        Iterable elems = (Iterable)((Tuple2)option2.get())._2();
        ActorPath actorPath = new RootActorPath(addr, RootActorPath$.MODULE$.apply$default$2()).$div((scala.collection.Iterable<String>)elems);
        return actorPath;
    }

    public Regex ElementRegex() {
        return this.ElementRegex;
    }

    private final String ValidSymbols() {
        return "-_.*$+:@&=,!~';";
    }

    private final int ValidPathCode() {
        return -1;
    }

    private final int EmptyPathCode() {
        return -2;
    }

    public final void validatePathElement(String element2) {
        this.validatePathElement(element2, null);
    }

    public final void validatePathElement(String element2, String fullPath) {
        int n = this.findInvalidPathElementCharPosition(element2);
        switch (n) {
            default: {
                throw new InvalidActorNameException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid actor path element [", "]", ", illegal character [", "] at position: ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{element2, this.fullPathMsg$1(fullPath), BoxesRunTime.boxToCharacter((char)StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(element2), n)), BoxesRunTime.boxToInteger((int)n)}))).append((Object)"Actor paths MUST: ").append((Object)"not start with `$`, ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"include only ASCII letters and can only contain these special characters: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"-_.*$+:@&=,!~';"}))).toString());
            }
            case -2: {
                throw new InvalidActorNameException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Actor path element must not be empty ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fullPathMsg$1(fullPath)})));
            }
            case -1: 
        }
    }

    public final boolean isValidPathElement(String s) {
        return this.findInvalidPathElementCharPosition(s) == -1;
    }

    private final int findInvalidPathElementCharPosition(String s) {
        int len2;
        return s.isEmpty() ? -2 : ((len2 = s.length()) > 0 && s.charAt(0) != '$' ? this.validate$1(0, s, len2) : 0);
    }

    public final Iterable<String> emptyActorPath() {
        return this.emptyActorPath;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final String fullPathMsg$1(String fullPath$1) {
        return fullPath$1 != null ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" (in path [", "])"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fullPath$1})) : "";
    }

    private final boolean isValidChar$1(char c2) {
        return c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || "-_.*$+:@&=,!~';".indexOf(c2) != -1;
    }

    private final boolean isHexChar$1(char c2) {
        return c2 >= 'a' && c2 <= 'f' || c2 >= 'A' && c2 <= 'F' || c2 >= '0' && c2 <= '9';
    }

    private final int validate$1(int pos, String s$1, int len$1) {
        int n;
        block3: {
            while (pos < len$1) {
                int n2;
                char c2 = s$1.charAt(pos);
                if (this.isValidChar$1(c2)) {
                    ++pos;
                    continue;
                }
                if ('%' == c2 && pos + 2 < len$1 && this.isHexChar$1(s$1.charAt(pos + 1)) && this.isHexChar$1(s$1.charAt(pos + 2))) {
                    pos += 3;
                    continue;
                }
                n = n2 = pos;
                break block3;
            }
            n = -1;
        }
        return n;
    }

    private ActorPath$() {
        MODULE$ = this;
        this.ElementRegex = new StringOps(Predef$.MODULE$.augmentString("(?:[-\\w:@&=+,.!~*'_;]|%\\p{XDigit}{2})(?:[-\\w:@&=+,.!~*'$_;]|%\\p{XDigit}{2})*")).r();
        this.emptyActorPath = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}));
    }
}

