/*
 * Decompiled with CFR 0.152.
 */
package com.bigstep.datalake;

import com.bigstep.datalake.AuthToken;
import com.bigstep.datalake.KerberosIdentity;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import org.apache.hadoop.security.authentication.client.PseudoAuthenticator;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Encoder;

public class KerberosIdentityAuthenticator
implements Authenticator {
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String AUTHORIZATION = "Authorization";
    public static final String NEGOTIATE = "Negotiate";
    private static final String AUTH_HTTP_METHOD = "OPTIONS";
    private static Logger LOG = LoggerFactory.getLogger(KerberosIdentityAuthenticator.class);
    private URL url;
    private HttpURLConnection conn;
    private Base64 base64;
    private ConnectionConfigurator connConfigurator;
    private KerberosIdentity kerberosIdentity;

    public KerberosIdentityAuthenticator(KerberosIdentity identity) {
        this.kerberosIdentity = identity;
    }

    public void setConnectionConfigurator(ConnectionConfigurator configurator) {
        this.connConfigurator = configurator;
    }

    public void authenticate(URL url, AuthenticatedURL.Token token) throws IOException, AuthenticationException {
        if (!token.isSet()) {
            this.url = url;
            this.base64 = new Base64(0);
            this.conn = (HttpURLConnection)url.openConnection();
            if (this.connConfigurator != null) {
                this.conn = this.connConfigurator.configure(this.conn);
            }
            this.conn.setRequestMethod(AUTH_HTTP_METHOD);
            this.conn.connect();
            boolean needFallback = false;
            if (this.conn.getResponseCode() == 200) {
                LOG.debug("JDK performed authentication on our behalf.");
                AuthenticatedURL.extractToken((HttpURLConnection)this.conn, (AuthenticatedURL.Token)token);
                if (this.isTokenKerberos(token)) {
                    return;
                }
                needFallback = true;
            }
            if (!needFallback && this.isNegotiate()) {
                LOG.debug("Performing our own SPNEGO sequence.");
                this.doSpnegoSequence(token);
            } else {
                LOG.debug("Using fallback authenticator sequence.");
                Authenticator auth = this.getFallBackAuthenticator();
                auth.setConnectionConfigurator(this.connConfigurator);
                auth.authenticate(url, token);
            }
        }
    }

    protected Authenticator getFallBackAuthenticator() {
        PseudoAuthenticator auth = new PseudoAuthenticator();
        if (this.connConfigurator != null) {
            auth.setConnectionConfigurator(this.connConfigurator);
        }
        return auth;
    }

    private boolean isTokenKerberos(AuthenticatedURL.Token token) throws AuthenticationException {
        AuthToken aToken;
        return token.isSet() && ((aToken = AuthToken.parse(token.toString())).getType().equals("kerberos") || aToken.getType().equals("kerberos-dt"));
    }

    private boolean isNegotiate() throws IOException {
        boolean negotiate = false;
        if (this.conn.getResponseCode() == 401) {
            String authHeader = this.conn.getHeaderField(WWW_AUTHENTICATE);
            negotiate = authHeader != null && authHeader.trim().startsWith(NEGOTIATE);
        }
        return negotiate;
    }

    private void doSpnegoSequence(AuthenticatedURL.Token atoken) throws IOException, AuthenticationException {
        try {
            this.kerberosIdentity.doAsPriviledged(new PrivilegedExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void run() throws Exception {
                    Oid KERB_V5_OID = new Oid("1.2.840.113554.1.2.2");
                    GSSContext gssContext = null;
                    try {
                        GSSManager gssManager = GSSManager.getInstance();
                        GSSName clientName = gssManager.createName(KerberosIdentityAuthenticator.this.kerberosIdentity.getPrincipalName(), GSSName.NT_USER_NAME);
                        LOG.info("doSpnegoSequence() using principal:" + KerberosIdentityAuthenticator.this.kerberosIdentity.getPrincipalName());
                        GSSCredential clientCred = gssManager.createCredential(clientName, 28800, KERB_V5_OID, 1);
                        String applicationPrincipal = "HTTP@" + KerberosIdentityAuthenticator.this.kerberosIdentity.getRealm();
                        GSSName serverName = gssManager.createName(applicationPrincipal, GSSName.NT_HOSTBASED_SERVICE);
                        gssContext = gssManager.createContext(serverName, KERB_V5_OID, clientCred, 0);
                        gssContext.requestCredDeleg(true);
                        gssContext.requestMutualAuth(true);
                        gssContext.requestConf(false);
                        gssContext.requestInteg(true);
                        byte[] inToken = new byte[]{};
                        boolean established = false;
                        while (!established) {
                            LOG.info("doSpnegoSequence() using token:" + new BASE64Encoder().encode(inToken));
                            byte[] outToken = gssContext.initSecContext(inToken, 0, 0);
                            LOG.info("initSecContext() out token:" + new BASE64Encoder().encode(outToken));
                            if (outToken != null) {
                                KerberosIdentityAuthenticator.this.sendToken(outToken);
                            }
                            if (!gssContext.isEstablished()) {
                                inToken = KerberosIdentityAuthenticator.this.readToken();
                                continue;
                            }
                            established = true;
                        }
                    }
                    finally {
                        if (gssContext != null) {
                            gssContext.dispose();
                            gssContext = null;
                        }
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException ex) {
            throw new AuthenticationException((Throwable)ex.getException());
        }
        AuthenticatedURL.extractToken((HttpURLConnection)this.conn, (AuthenticatedURL.Token)atoken);
    }

    private void sendToken(byte[] outToken) throws IOException {
        String token = this.base64.encodeToString(outToken);
        this.conn = (HttpURLConnection)this.url.openConnection();
        if (this.connConfigurator != null) {
            this.conn = this.connConfigurator.configure(this.conn);
        }
        this.conn.setRequestMethod(AUTH_HTTP_METHOD);
        this.conn.setRequestProperty(AUTHORIZATION, "Negotiate " + token);
        this.conn.connect();
    }

    private byte[] readToken() throws IOException, AuthenticationException {
        int status = this.conn.getResponseCode();
        if (status == 200 || status == 401) {
            String authHeader = this.conn.getHeaderField(WWW_AUTHENTICATE);
            if (authHeader == null || !authHeader.trim().startsWith(NEGOTIATE)) {
                throw new AuthenticationException("Invalid SPNEGO sequence, 'WWW-Authenticate' header incorrect: " + authHeader);
            }
            String negotiation = authHeader.trim().substring("Negotiate ".length()).trim();
            return this.base64.decode(negotiation);
        }
        throw new AuthenticationException("Invalid SPNEGO sequence, status code: " + status);
    }
}

